/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.analyzer.BrazilianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.BulgarianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CJKAnalyzer;
import com.atlassian.jira.issue.index.analyzer.CzechAnalyzer;
import com.atlassian.jira.issue.index.analyzer.EnglishAnalyzer;
import com.atlassian.jira.issue.index.analyzer.FrenchAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GermanAnalyzer;
import com.atlassian.jira.issue.index.analyzer.GreekAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ItalianAnalyzer;
import com.atlassian.jira.issue.index.analyzer.SimpleAnalyzer;
import com.atlassian.jira.issue.index.analyzer.StemmingAnalyzer;
import com.atlassian.jira.issue.index.analyzer.TextAnalyzer;
import com.atlassian.jira.issue.index.analyzer.ThaiAnalyzer;
import com.atlassian.jira.issue.index.analyzer.TokenFilters;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAnalyzer
extends Analyzer {
    private final boolean indexing;
    private final Stemming stemming;
    private final StopWordRemoval stopWordRemoval;
    private static final Logger log = LoggerFactory.getLogger(JiraAnalyzer.class);
    public static final Analyzer ANALYZER_FOR_INDEXING = JiraAnalyzer.createAnalyzerForIndexing();
    public static final Analyzer ANALYZER_FOR_SEARCHING = JiraAnalyzer.createAnalyzerForSearching();
    public static final Analyzer ANALYZER_FOR_EXACT_SEARCHING = new JiraAnalyzer(false, Stemming.OFF, StopWordRemoval.OFF);
    @ClusterSafe(value="Lazy creation of expensive but stateless objects")
    private final LoadingCache<String, TextAnalyzer> analyzers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TextAnalyzer>(){

        public TextAnalyzer load(@Nonnull String key) throws Exception {
            return JiraAnalyzer.this.makeAnalyzer(key);
        }
    });
    private final TextAnalyzer fallbackAnalyzer;

    public JiraAnalyzer(boolean indexing, Stemming stemming, StopWordRemoval stopWordRemoval) {
        this.indexing = indexing;
        this.stemming = stemming;
        this.stopWordRemoval = stopWordRemoval;
        this.fallbackAnalyzer = new SimpleAnalyzer(this.indexing);
    }

    TextAnalyzer makeAnalyzer(String language) {
        if (language.equals("armenian")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Armenian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Armenian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("basque")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Basque.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Basque.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("bulgarian")) {
            return new BulgarianAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Bulgarian.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Bulgarian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("brazilian")) {
            return new BrazilianAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Portuguese.Brazil.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Portuguese.Brazil.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("catalan")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Catalan.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Catalan.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("chinese")) {
            return new SimpleAnalyzer(this.indexing);
        }
        if (language.equals("cjk")) {
            return new CJKAnalyzer(this.indexing, this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.CJK.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("czech")) {
            return new CzechAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Czech.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Czech.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("danish")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Danish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Danish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("dutch")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Dutch.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Dutch.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english")) {
            return new EnglishAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english-moderate-stemming")) {
            return new EnglishAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.moderate() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("english-minimal-stemming")) {
            return new EnglishAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.English.Stemming.minimal() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.English.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("finnish")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Finnish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Finnish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("french")) {
            return new FrenchAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.French.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.French.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("german")) {
            return new GermanAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.German.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.German.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("greek")) {
            return new GreekAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Greek.Stemming.standard() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Greek.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("hungarian")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Hungarian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Hungarian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("italian")) {
            return new ItalianAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Italian.Stemming.agressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Italian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("norwegian")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Norwegian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Norwegian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("portuguese")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Portuguese.Portugal.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Portuguese.Portugal.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("romanian")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Romanian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Romanian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("russian")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Russian.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Russian.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("spanish")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Spanish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Spanish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("swedish")) {
            return new StemmingAnalyzer(this.indexing, this.stemming == Stemming.ON ? TokenFilters.Swedish.Stemming.aggressive() : TokenFilters.General.Stemming.none(), this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Swedish.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("thai")) {
            return new ThaiAnalyzer(this.indexing, this.stopWordRemoval == StopWordRemoval.ON ? TokenFilters.Thai.StopWordRemoval.defaultSet() : TokenFilters.General.StopWordRemoval.none());
        }
        if (language.equals("other")) {
            return this.fallbackAnalyzer;
        }
        return this.fallbackAnalyzer;
    }

    public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
        if (fieldName == null) {
            fieldName = "";
        }
        TextAnalyzer analyzer = this.findAnalyzer();
        return analyzer.createComponents(fieldName);
    }

    private TextAnalyzer findAnalyzer() {
        String language = this.getLanguage();
        if (language == null) {
            return this.fallbackAnalyzer;
        }
        TextAnalyzer analyzer = null;
        try {
            analyzer = (TextAnalyzer)((Object)this.analyzers.get((Object)language));
        }
        catch (ExecutionException e) {
            log.error("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'.");
            analyzer = this.fallbackAnalyzer;
        }
        if (analyzer == null) {
            log.error("Invalid indexing language: '" + language + "', defaulting to '" + "other" + "'.");
            analyzer = this.fallbackAnalyzer;
        }
        return analyzer;
    }

    String getLanguage() {
        return ComponentAccessor.getApplicationProperties().getString("jira.i18n.language.index");
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    @VisibleForTesting
    public static final PerFieldIndexingAnalyzer createAnalyzerForIndexing() {
        return new PerFieldIndexingAnalyzer();
    }

    @VisibleForTesting
    protected static final Analyzer createAnalyzerForSearching() {
        return new JiraAnalyzer(false, Stemming.ON, StopWordRemoval.ON);
    }

    private static class PerFieldIndexingAnalyzer
    extends Analyzer {
        private final JiraAnalyzer PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER = new JiraAnalyzer(true, Stemming.OFF, StopWordRemoval.OFF);
        private final JiraAnalyzer TEXT_FIELD_INDEXING_ANALYZER = new JiraAnalyzer(true, Stemming.ON, StopWordRemoval.ON);

        public PerFieldIndexingAnalyzer() {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            if (PhraseQuerySupportField.isPhraseQuerySupportField((String)fieldName)) {
                return this.PHRASE_QUERY_SUPPORT_TEXT_FIELD_ANALYZER.createComponents(fieldName);
            }
            return this.TEXT_FIELD_INDEXING_ANALYZER.createComponents(fieldName);
        }
    }

    public static enum StopWordRemoval {
        ON,
        OFF;

    }

    public static enum Stemming {
        ON,
        OFF;

    }
}

