/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.CustomFieldIndexerWithStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStats;
import com.atlassian.jira.issue.index.indexers.FieldIndexerStatsCollector;
import com.atlassian.jira.issue.index.managers.NonNullCustomFieldProviderStats;
import com.atlassian.jira.util.stats.LongStats;
import com.atlassian.jira.util.stats.MutableLongStats;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;

public class FieldIndexerWithStats
implements FieldIndexer,
FieldIndexerStatsCollector {
    private final FieldIndexer delegate;
    private final boolean isKnown;
    protected final MutableFieldIndexerStats stats = new MutableFieldIndexerStats();
    private Ticker ticker = Ticker.systemTicker();

    protected FieldIndexerWithStats(boolean isKnown, FieldIndexer delegate) {
        this.isKnown = isKnown;
        this.delegate = delegate;
    }

    public FieldIndexerWithStats overrideTicker(Ticker ticker) {
        Preconditions.checkNotNull((Object)ticker);
        this.ticker = ticker;
        return this;
    }

    public static FieldIndexerWithStats createKnown(FieldIndexer delegate) {
        return new FieldIndexerWithStats(true, delegate);
    }

    public static FieldIndexerWithStats createOther(FieldIndexer delegate) {
        return new FieldIndexerWithStats(false, delegate);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getDocumentFieldId() {
        return this.delegate.getDocumentFieldId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(Document doc, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        try {
            this.delegate.addIndex(doc, issue, prefetchedData);
        }
        finally {
            this.stats.addIndex(stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldVisibleAndInScope(Issue issue) {
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)this.ticker);
        try {
            boolean bl = this.delegate.isFieldVisibleAndInScope(issue);
            return bl;
        }
        finally {
            this.stats.isFieldVisibleAndInScope(stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    public Boolean skipsIndexingNull() {
        return this.delegate.skipsIndexingNull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldIndexerWithStats that = (FieldIndexerWithStats)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FieldIndexerWithStats{");
        sb.append("delegate=").append(this.delegate);
        sb.append(", isKnown=").append(this.isKnown);
        sb.append(", stats=").append(this.stats);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Stats getStatsAndResetSnapshot() {
        try {
            Stats stats = this.getStats();
            return stats;
        }
        finally {
            this.stats.resetSnapshot();
        }
    }

    @Override
    public void resetStats() {
        this.stats.reset();
    }

    @Override
    public Stats getStats() {
        return new Stats(this);
    }

    @Deprecated
    public Stats stats() {
        return this.getStats();
    }

    @Deprecated
    public Stats resetSnapshot() {
        return this.getStatsAndResetSnapshot();
    }

    @Deprecated
    public void reset() {
        this.resetStats();
    }

    public static class Stats
    implements FieldIndexerStats {
        private final boolean isKnown;
        private final String id;
        private final String documentFieldId;
        private final LongStats totalTimeToAddIndexMicros;
        private final LongStats snapshotTimeToAddIndexMicros;
        private final LongStats totalTimeToIsFieldVisibleAndInScopeMicros;
        private final LongStats snapshotTimeToIsFieldVisibleAndInScopeMicros;
        private final String indexerClassName;
        private final Boolean declaresNullHandling;
        private final String customFieldTypeClassName;
        private final Long customFieldID;
        private final Boolean declaresNonNullValueProvider;
        private final NonNullCustomFieldProviderStats nonNullCustomFieldProviderStats;

        Stats(FieldIndexerWithStats fieldIndexerWithStats) {
            this.isKnown = fieldIndexerWithStats.isKnown;
            this.id = fieldIndexerWithStats.getId();
            this.documentFieldId = fieldIndexerWithStats.getDocumentFieldId();
            this.totalTimeToAddIndexMicros = fieldIndexerWithStats.stats.totalTimeToAddIndexMicros.get();
            this.snapshotTimeToAddIndexMicros = fieldIndexerWithStats.stats.snapshotTimeToAddIndexMicros.get();
            this.totalTimeToIsFieldVisibleAndInScopeMicros = fieldIndexerWithStats.stats.totalTimeToIsFieldVisibleAndInScopeMicros.get();
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros = fieldIndexerWithStats.stats.snapshotTimeToIsFieldVisibleAndInScopeMicros.get();
            this.indexerClassName = fieldIndexerWithStats.delegate.getClass().getName();
            this.declaresNullHandling = fieldIndexerWithStats.delegate.skipsIndexingNull();
            if (fieldIndexerWithStats instanceof CustomFieldIndexerWithStats) {
                CustomField customField = ((CustomFieldIndexerWithStats)fieldIndexerWithStats).getField();
                CustomFieldType customFieldType = customField.getCustomFieldType();
                this.customFieldTypeClassName = customFieldType.getClass().getName();
                this.customFieldID = customField.getIdAsLong();
                this.declaresNonNullValueProvider = customFieldType.getNonNullCustomFieldProvider() != null;
            } else {
                this.customFieldTypeClassName = null;
                this.customFieldID = null;
                this.declaresNonNullValueProvider = null;
            }
            this.nonNullCustomFieldProviderStats = null;
        }

        private Stats(Stats stats, NonNullCustomFieldProviderStats nonNullCustomFieldProviderStats) {
            this.isKnown = stats.isKnown;
            this.id = stats.id;
            this.documentFieldId = stats.documentFieldId;
            this.totalTimeToAddIndexMicros = stats.totalTimeToAddIndexMicros;
            this.snapshotTimeToAddIndexMicros = stats.snapshotTimeToAddIndexMicros;
            this.totalTimeToIsFieldVisibleAndInScopeMicros = stats.totalTimeToIsFieldVisibleAndInScopeMicros;
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros = stats.snapshotTimeToIsFieldVisibleAndInScopeMicros;
            this.indexerClassName = stats.indexerClassName;
            this.declaresNullHandling = stats.declaresNullHandling;
            this.customFieldTypeClassName = stats.customFieldTypeClassName;
            this.customFieldID = stats.customFieldID;
            this.declaresNonNullValueProvider = stats.declaresNonNullValueProvider;
            this.nonNullCustomFieldProviderStats = nonNullCustomFieldProviderStats;
        }

        @Override
        public boolean isKnown() {
            return this.isKnown;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String documentFieldId() {
            return this.documentFieldId;
        }

        @Override
        public LongStats totalTimeToAddIndexMicros() {
            if (this.nonNullCustomFieldProviderStats == null) {
                return this.totalTimeToAddIndexMicros;
            }
            LongStats stats = this.nonNullCustomFieldProviderStats.totalTimeGetCustomFieldInfo(this.id);
            return stats != null ? LongStats.averageMergeWithOther(this.totalTimeToAddIndexMicros, stats) : this.totalTimeToAddIndexMicros;
        }

        @Override
        public LongStats snapshotTimeToAddIndexMicros() {
            if (this.nonNullCustomFieldProviderStats == null) {
                return this.snapshotTimeToAddIndexMicros;
            }
            LongStats stats = this.nonNullCustomFieldProviderStats.snapshotTimeGetCustomFieldInfo(this.id);
            return stats != null ? LongStats.averageMergeWithOther(this.snapshotTimeToAddIndexMicros, stats) : this.snapshotTimeToAddIndexMicros;
        }

        @Override
        public LongStats totalTimeToIsFieldVisibleAndInScopeMicros() {
            return this.totalTimeToIsFieldVisibleAndInScopeMicros;
        }

        @Override
        public LongStats snapshotTimeToIsFieldVisibleAndInScopeMicros() {
            return this.snapshotTimeToIsFieldVisibleAndInScopeMicros;
        }

        @Override
        public String getIndexerClassName() {
            return this.indexerClassName;
        }

        @Override
        public Boolean getDeclaresNullHandling() {
            return this.declaresNullHandling;
        }

        @Override
        public String getCustomFieldTypeClassName() {
            return this.customFieldTypeClassName;
        }

        @Override
        public Long getCustomFieldID() {
            return this.customFieldID;
        }

        @Override
        public Boolean getDeclaresNonNullValueProvider() {
            return this.declaresNonNullValueProvider;
        }

        @Override
        public FieldIndexerStats mergeStats(NonNullCustomFieldProviderStats nonNullCustomFieldProviderStats) {
            return new Stats(this, nonNullCustomFieldProviderStats);
        }
    }

    private static class MutableFieldIndexerStats {
        private final MutableLongStats totalTimeToAddIndexMicros = new MutableLongStats(new long[0]);
        private final MutableLongStats snapshotTimeToAddIndexMicros = new MutableLongStats(new long[0]);
        private final MutableLongStats totalTimeToIsFieldVisibleAndInScopeMicros = new MutableLongStats(new long[0]);
        private final MutableLongStats snapshotTimeToIsFieldVisibleAndInScopeMicros = new MutableLongStats(new long[0]);

        private MutableFieldIndexerStats() {
        }

        void addIndex(long timeToAddMicros) {
            this.totalTimeToAddIndexMicros.accept(timeToAddMicros);
            this.snapshotTimeToAddIndexMicros.accept(timeToAddMicros);
        }

        void isFieldVisibleAndInScope(long timeToAddMicros) {
            this.totalTimeToIsFieldVisibleAndInScopeMicros.accept(timeToAddMicros);
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros.accept(timeToAddMicros);
        }

        void resetSnapshot() {
            this.snapshotTimeToAddIndexMicros.reset();
            this.snapshotTimeToIsFieldVisibleAndInScopeMicros.reset();
        }

        void resetTotal() {
            this.totalTimeToAddIndexMicros.reset();
            this.totalTimeToIsFieldVisibleAndInScopeMicros.reset();
        }

        void reset() {
            this.resetSnapshot();
            this.resetTotal();
        }
    }
}

