/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.AbstractProgressBarSystemField;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressIndexer
extends BaseFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(ProgressIndexer.class);
    private static final String PROGRESS_UNKNOWN = "-1";
    private final ApplicationProperties applicationProperties;

    public ProgressIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        super(fieldVisibilityManager);
        this.applicationProperties = applicationProperties;
    }

    public String getId() {
        return "progress";
    }

    public String getDocumentFieldId() {
        return "progress";
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    public void addIndex(Document doc, Issue issue) {
        try {
            Long percentage = AbstractProgressBarSystemField.calculateProgressPercentage(issue.getTimeSpent(), issue.getEstimate());
            if (this.isFieldVisibleAndInScope(issue)) {
                doc.add((IndexableField)new StringField(this.getDocumentFieldId(), percentage == null ? PROGRESS_UNKNOWN : percentage.toString(), Field.Store.YES));
                if (percentage != null) {
                    doc.add((IndexableField)new NumericDocValuesField(this.getDocumentFieldId(), percentage.longValue()));
                }
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), percentage == null ? PROGRESS_UNKNOWN : percentage.toString()));
            }
        }
        catch (IllegalArgumentException mustBeNegative) {
            log.warn("Issue: '" + issue.getKey() + "' has an uncalculable percentage", (Throwable)mustBeNegative);
        }
    }
}

