/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchQuery;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.PrefixFieldHitCollector;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public class PrefixSearchLabelsProvider {
    public Set<String> findByPrefixToken(String prefix, String searchField, String displayField, ApplicationUser searchUser) {
        TreeSet<String> suggestions = new TreeSet<String>();
        try {
            this.getSearchProvider().search(SearchQuery.create((com.atlassian.query.Query)new SearchRequest().getQuery(), (ApplicationUser)searchUser).luceneQuery(this.createLuceneQuery(prefix, searchField)), (Collector)this.createCollector(prefix, displayField, suggestions));
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return suggestions;
    }

    private PrefixFieldHitCollector createCollector(String prefix, String displayField, Set<String> suggestions) {
        return new PrefixFieldHitCollector(displayField, prefix, suggestions);
    }

    private Query createLuceneQuery(String prefix, String searchField) {
        return new PrefixQuery(new Term(searchField, prefix.toLowerCase()));
    }

    private SearchProvider getSearchProvider() {
        return (SearchProvider)ComponentAccessor.getComponentOfType(SearchProvider.class);
    }
}

