/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.auditing.handlers.IssueLinkingHandler;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeImpl;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.model.querydsl.QIssueLinkType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultIssueLinkTypeManager
implements IssueLinkTypeManager {
    private final OfBizDelegator delegator;
    private final QueryDslAccessor dbConnectionManager;
    private final CachedReference<Map<Long, IssueLinkType>> cache;
    private final IssueLinkingHandler issueLinkingHandler;

    public DefaultIssueLinkTypeManager(OfBizDelegator delegator, QueryDslAccessor dbConnectionManager, CacheManager cacheManager, IssueLinkingHandler issueLinkingHandler) {
        this.delegator = delegator;
        this.dbConnectionManager = dbConnectionManager;
        this.cache = cacheManager.getCachedReference(this.getClass().getName() + ".types", this::loadIssueLinkTypes);
        this.issueLinkingHandler = issueLinkingHandler;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIssueLinkType(String name, String outward, String inward, String style) {
        try {
            Assertions.notBlank((String)"name", (String)name);
            Assertions.notBlank((String)"outward", (String)outward);
            Assertions.notBlank((String)"inward", (String)inward);
            this.dbConnectionManager.withNewConnection().execute(dbConnection -> dbConnection.insert(QIssueLinkType.ISSUE_LINK_TYPE).withId().set((Path)QIssueLinkType.ISSUE_LINK_TYPE.linkname, name).set((Path)QIssueLinkType.ISSUE_LINK_TYPE.outward, outward).set((Path)QIssueLinkType.ISSUE_LINK_TYPE.inward, inward).set((Path)QIssueLinkType.ISSUE_LINK_TYPE.style, style).execute());
        }
        finally {
            this.clearCache();
        }
    }

    public IssueLinkType getIssueLinkType(Long id) {
        return this.getIssueLinkType(id, true);
    }

    public IssueLinkType getIssueLinkType(Long id, boolean excludeSystemLinks) {
        return (IssueLinkType)((Map)this.cache.get()).get(id);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByName(String name) {
        return this.buildIssueLinkTypes(this.queryDatabase("IssueLinkType", MapBuilder.build((Object)"linkname", (Object)name)), false);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByInwardDescription(final String desc) {
        com.atlassian.jira.util.Predicate<GenericValue> inwardNamePredicate = new com.atlassian.jira.util.Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return input.getString("inward").equalsIgnoreCase(desc);
            }
        };
        return this.getIssueLinkTypesByPredicate(inwardNamePredicate);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByOutwardDescription(final String desc) {
        com.atlassian.jira.util.Predicate<GenericValue> inwardNamePredicate = new com.atlassian.jira.util.Predicate<GenericValue>(){

            public boolean evaluate(GenericValue input) {
                return input.getString("outward").equalsIgnoreCase(desc);
            }
        };
        return this.getIssueLinkTypesByPredicate(inwardNamePredicate);
    }

    private Collection<IssueLinkType> getIssueLinkTypesByPredicate(com.atlassian.jira.util.Predicate<GenericValue> predicate) {
        Collection inwardLinkTypes = CollectionUtil.filter(this.queryDatabase("IssueLinkType", MapBuilder.emptyMap()), predicate);
        return this.buildIssueLinkTypes(inwardLinkTypes, false);
    }

    public Collection<IssueLinkType> getIssueLinkTypesByStyle(String style) {
        return this.buildIssueLinkTypes(this.queryDatabase("IssueLinkType", MapBuilder.build((Object)"style", (Object)style)), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssueLinkType(IssueLinkType issueLinkType, String name, String outward, String inward) {
        try {
            this.dbConnectionManager.withNewConnection().execute(dbConnection -> {
                QIssueLinkType ilt = new QIssueLinkType("ilt");
                dbConnection.update((RelationalPath<?>)ilt).set((Path)ilt.linkname, (Object)name).set((Path)ilt.outward, (Object)outward).set((Path)ilt.inward, (Object)inward).where((Predicate)ilt.id.eq((Object)issueLinkType.getId())).execute();
            });
            this.issueLinkingHandler.handleIssueLinkTypeUpdate(issueLinkType, name, outward, inward);
        }
        finally {
            this.clearCache();
        }
    }

    public void removeIssueLinkType(Long issueLinkTypeId) {
        try {
            this.deleteFromDatabase("IssueLinkType", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)issueLinkTypeId));
        }
        finally {
            this.clearCache();
        }
    }

    public Collection<IssueLinkType> getIssueLinkTypes() {
        return this.getIssueLinkTypes(true);
    }

    public Collection<IssueLinkType> getIssueLinkTypes(boolean excludeSystemLinks) {
        ImmutableList types = ImmutableList.copyOf(((Map)this.cache.get()).values());
        if (!excludeSystemLinks) {
            return types;
        }
        return CollectionUtil.filter((Collection)types, (com.atlassian.jira.util.Predicate)new com.atlassian.jira.util.Predicate<IssueLinkType>(){

            public boolean evaluate(IssueLinkType type) {
                return !type.isSystemLinkType();
            }
        });
    }

    private List<IssueLinkType> buildIssueLinkTypes(Collection<GenericValue> issueLinkTypeGVs, boolean excludeSystemLinks) {
        ArrayList<IssueLinkType> issueLinkTypes = new ArrayList<IssueLinkType>(issueLinkTypeGVs.size());
        for (GenericValue issueLinkTypeGV : issueLinkTypeGVs) {
            IssueLinkType ilt = this.buildIssueLinkType(issueLinkTypeGV);
            if (excludeSystemLinks && ilt.isSystemLinkType()) continue;
            issueLinkTypes.add(ilt);
        }
        return issueLinkTypes;
    }

    private void clearCache() {
        this.cache.reset();
    }

    private IssueLinkType buildIssueLinkType(GenericValue linkTypeGV) {
        return new IssueLinkTypeImpl(linkTypeGV);
    }

    private List<GenericValue> queryDatabase(String entityName, Map<String, Object> criteria) {
        List<String> sortOrder = Collections.emptyList();
        return this.queryDatabase(entityName, criteria, sortOrder);
    }

    private List<GenericValue> queryDatabase(String entityName, Map<String, Object> criteria, List<String> sortOrder) {
        return this.delegator.findByAnd(entityName, criteria, sortOrder);
    }

    private void deleteFromDatabase(String entityName, Map<String, ?> criteria) {
        this.delegator.removeByAnd(entityName, criteria);
    }

    public Map<Long, IssueLinkType> loadIssueLinkTypes() {
        LinkedHashMap<Long, IssueLinkType> types = new LinkedHashMap<Long, IssueLinkType>();
        List gvTypes = this.delegator.findAll("IssueLinkType", (List)ImmutableList.of((Object)"linkname ASC"));
        if (gvTypes != null) {
            for (GenericValue gv : gvTypes) {
                IssueLinkType type = this.buildIssueLinkType(gv);
                types.put(type.getId(), type);
            }
        }
        return types;
    }
}

