/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.event.issue.field.CustomFieldSelectedForDeletionEvent;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldBulkDeleteManager {
    public static final int MAX_NUMBER_OF_CUSTOM_FIELDS_TO_DELETE = 50;
    public static final String BULK_DELETE_FEATURE_FLAG = JiraFeatureFlagRegistrar.CUSTOMFIELDS_BULK_DELETE.featureKey();
    public static final String BULK_DELETE_LOCK_NAME = CustomFieldBulkDeleteManager.class.getName() + ".remove.customfields";
    public static final String LOCK_NOT_ACQUIRED_MESSAGE = "Could not obtain cluster lock for Custom fields bulk deletion operation.";
    public static final String VALIDATION_FOR_CUSTOM_FIELD_DELETION_FAILED_MESSAGE = "Validation for custom field deletion failed.";
    private final ResettableLazyReference<Boolean> isDcLicensed = Lazy.resettable((Supplier)new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            return CustomFieldBulkDeleteManager.this.clusterManager.isClusterLicensed();
        }
    });
    private final Logger log = LoggerFactory.getLogger(CustomFieldBulkDeleteManager.class);
    private final CustomFieldManager customFieldManager;
    private final CustomFieldService customFieldService;
    private final ClusterManager clusterManager;
    private final FeatureManager featureManager;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final ClusterLockService clusterLockService;
    private final FieldScreenManager fieldScreenManager;
    private final EventPublisher eventPublisher;

    public CustomFieldBulkDeleteManager(CustomFieldManager customFieldManager, CustomFieldService customFieldService, ClusterManager clusterManager, FeatureManager featureManager, ManagedConfigurationItemService managedConfigurationItemService, ClusterLockService clusterLockService, FieldScreenManager fieldScreenManager, EventPublisher eventPublisher) {
        this.customFieldManager = customFieldManager;
        this.customFieldService = customFieldService;
        this.clusterManager = clusterManager;
        this.featureManager = featureManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.clusterLockService = clusterLockService;
        this.fieldScreenManager = fieldScreenManager;
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    public boolean isDCAndFeatureFlagOn() {
        return (Boolean)this.isDcLicensed.get() != false && this.featureManager.isEnabled(BULK_DELETE_FEATURE_FLAG);
    }

    public boolean validateNumberOfArguments(List<String> customFields) {
        return customFields != null && !customFields.isEmpty() && customFields.size() <= 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> validateAndDeleteCustomFields(JiraAuthenticationContext jiraAuthenticationContext, List<String> customFieldsIds, Long bulkOperationStartTime) {
        HashMap<String, String> notDeletedCustomFields = new HashMap<String, String>();
        if (customFieldsIds.size() == 1) {
            this.validateAndDeleteCustomField(jiraAuthenticationContext, notDeletedCustomFields, customFieldsIds.get(0), bulkOperationStartTime);
        } else {
            ClusterLock clusterLock = this.clusterLockService.getLockForName(BULK_DELETE_LOCK_NAME);
            if (!clusterLock.tryLock()) {
                this.log.warn(LOCK_NOT_ACQUIRED_MESSAGE);
                throw new LockNotAcquiredException(LOCK_NOT_ACQUIRED_MESSAGE);
            }
            try {
                for (String customFieldId : customFieldsIds) {
                    this.validateAndDeleteCustomField(jiraAuthenticationContext, notDeletedCustomFields, customFieldId, bulkOperationStartTime);
                }
            }
            finally {
                clusterLock.unlock();
            }
        }
        return notDeletedCustomFields;
    }

    private void validateAndDeleteCustomField(JiraAuthenticationContext jiraAuthenticationContext, Map<String, String> notDeletedCustomFields, String customFieldId, Long bulkOperationStartTime) {
        CustomFieldEventBuilder customFieldEventBuilder = this.customFieldManager.getCustomFieldObject(customFieldId) != null ? this.collectCustomFieldData(customFieldId).withBulkStartTime(bulkOperationStartTime) : new CustomFieldEventBuilder().withBulkStartTime(bulkOperationStartTime);
        try {
            Optional<String> canCustomFieldBeDeleted = this.customFieldCanBeDeleted(jiraAuthenticationContext, customFieldId);
            if (canCustomFieldBeDeleted.isPresent()) {
                this.log.warn("You cannot delete {}: {}", (Object)customFieldId, (Object)canCustomFieldBeDeleted.get());
                notDeletedCustomFields.put(customFieldId, canCustomFieldBeDeleted.get());
                this.eventPublisher.publish((Object)customFieldEventBuilder.wasDeleted(false).build());
            } else {
                Long startTime = System.currentTimeMillis();
                this.removeCustomField(customFieldId);
                Long endTime = System.currentTimeMillis();
                this.log.info("Custom field {} was successfully deleted. The process took {} ms", (Object)customFieldId, (Object)(endTime - startTime));
                this.eventPublisher.publish((Object)customFieldEventBuilder.withStartTime(startTime).withEndTime(endTime).wasDeleted(true).build());
            }
        }
        catch (RemoveException e) {
            this.log.warn(String.format("Error occurred while deleting custom field %s:", customFieldId), (Object)e.getMessage());
            notDeletedCustomFields.put(customFieldId, String.format("Error occurred while deleting custom field: %s", e.getMessage()));
            this.eventPublisher.publish((Object)customFieldEventBuilder.wasDeleted(false).build());
        }
        catch (RuntimeException e) {
            this.log.warn(String.format("Internal error occurred while deleting custom field %s:", customFieldId), (Object)e.getMessage());
            notDeletedCustomFields.put(customFieldId, String.format("Internal error occurred while deleting custom field: %s", e.getMessage()));
            this.eventPublisher.publish((Object)customFieldEventBuilder.wasDeleted(false).build());
        }
    }

    private Optional<String> customFieldCanBeDeleted(JiraAuthenticationContext jiraAuthenticationContext, String customFieldId) {
        if (!this.customFieldManager.isCustomField(customFieldId) || !NumberUtils.isParsable((String)customFieldId.split("_")[1])) {
            return Optional.of("Wrong custom field key format");
        }
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField == null) {
            return Optional.of("Custom field does not exist");
        }
        if (this.isFieldLocked(jiraAuthenticationContext, customField)) {
            return Optional.of("Custom field is locked");
        }
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(jiraAuthenticationContext.getLoggedInUser());
        this.customFieldService.validateDelete((JiraServiceContext)jiraServiceContext, customField.getIdAsLong());
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return Optional.of(VALIDATION_FOR_CUSTOM_FIELD_DELETION_FAILED_MESSAGE);
        }
        return Optional.empty();
    }

    private boolean isFieldLocked(JiraAuthenticationContext jiraAuthenticationContext, CustomField customField) {
        return !this.managedConfigurationItemService.doesUserHavePermission(jiraAuthenticationContext.getLoggedInUser(), this.managedConfigurationItemService.getManagedCustomField(customField));
    }

    private void removeCustomField(String customFieldId) throws RemoveException {
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        this.customFieldManager.removeCustomField(customField);
    }

    private CustomFieldEventBuilder collectCustomFieldData(String customFieldId) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        return new CustomFieldEventBuilder(customField.getIdAsLong(), customField.getLastValueUpdate() != null ? Long.valueOf(customField.getLastValueUpdate().getTime()) : null, customField.getIssuesWithValue(), Long.valueOf(customField.getAssociatedProjectObjects().size()), Long.valueOf(this.fieldScreenManager.getFieldScreenTabs(customField.getId()).size()));
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.isDcLicensed.reset();
    }

    public static class LockNotAcquiredException
    extends RuntimeException {
        LockNotAcquiredException(String message) {
            super(message);
        }
    }

    private static class CustomFieldEventBuilder {
        private final Long customFieldId;
        private Long lastValueUpdate;
        private Long issuesWithValue;
        private Long numberOfProjects;
        private Long numberOfScreens;
        private boolean deleted;
        private Long startTime;
        private Long endTime;
        private Long bulkStartTime;

        public CustomFieldEventBuilder() {
            this(0L);
        }

        public CustomFieldEventBuilder(Long customFieldId) {
            this.customFieldId = customFieldId;
        }

        public CustomFieldEventBuilder(Long customFieldId, Long lastValueUpdate, Long issuesWithValue, Long numberOfProjects, Long numberOfScreens) {
            this.customFieldId = customFieldId;
            this.lastValueUpdate = lastValueUpdate;
            this.issuesWithValue = issuesWithValue;
            this.numberOfProjects = numberOfProjects;
            this.numberOfScreens = numberOfScreens;
        }

        public CustomFieldEventBuilder wasDeleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public CustomFieldEventBuilder withStartTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public CustomFieldEventBuilder withEndTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public CustomFieldEventBuilder withBulkStartTime(Long bulkStartTime) {
            this.bulkStartTime = bulkStartTime;
            return this;
        }

        public CustomFieldSelectedForDeletionEvent build() {
            return new CustomFieldSelectedForDeletionEvent(this.customFieldId, this.lastValueUpdate, this.issuesWithValue, this.numberOfProjects, this.numberOfScreens, this.deleted, this.startTime, this.endTime, this.bulkStartTime);
        }
    }
}

