/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.ArchiveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.managers.DefaultIssueArchiveHelper;
import com.atlassian.jira.issue.managers.IssueArchiveHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.atlassian.jira.user.ApplicationUser;

public class ZduAwareIssueArchiveHelper
implements IssueArchiveHelper {
    private final DefaultIssueArchiveHelper delegate;
    private final ArchivedProjectManager archivedProjectManager;
    private final FeatureManager featureManager;
    private boolean projectArchivedIssuesMarkedInIssueTable;

    public ZduAwareIssueArchiveHelper(DefaultIssueArchiveHelper defaultIssueArchiveHelper, ArchivedProjectManager archivedProjectManager, FeatureManager featureManager) {
        this.delegate = defaultIssueArchiveHelper;
        this.archivedProjectManager = archivedProjectManager;
        this.featureManager = featureManager;
    }

    @Override
    public boolean isIssueArchived(Project project, boolean issueArchivedProperty) {
        if (this.isProjectArchivedIssuesMarkedInIssueTable()) {
            return this.delegate.isIssueArchived(project, issueArchivedProperty);
        }
        return this.delegate.isArchivingAllowed() && (issueArchivedProperty || this.archivedProjectManager.isProjectArchived(project));
    }

    @Override
    public Issue archiveIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        return this.delegate.archiveIssue(user, issue, eventDispatchOption, sendMail);
    }

    @Override
    public Issue restoreIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws ArchiveException {
        return this.delegate.restoreIssue(user, issue, eventDispatchOption, sendMail);
    }

    @Override
    public void archiveIssuesInProject(Project project) {
        this.delegate.archiveIssuesInProject(project);
    }

    @Override
    public void restoreIssuesInProject(Project project) {
        this.delegate.restoreIssuesInProject(project);
    }

    private boolean isProjectArchivedIssuesMarkedInIssueTable() {
        if (!this.projectArchivedIssuesMarkedInIssueTable) {
            this.projectArchivedIssuesMarkedInIssueTable = this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PROJECT_ARCHIVED_ISSUES_MARKED_IN_ISSUE_TABLE);
        }
        return this.projectArchivedIssuesMarkedInIssueTable;
    }
}

