/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.ComponentLocator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public final class SearchHandlerBuilderFactory {
    private final ComponentLocator locator;

    public SearchHandlerBuilderFactory(ComponentLocator locator) {
        this.locator = locator;
    }

    public SearchHandlerBuilder builder(ClauseInformation clauseInfo) {
        return new SearchHandlerBuilder(clauseInfo);
    }

    public final class SearchHandlerBuilder {
        private final ClauseInformation clauseInformation;
        private ClauseContextFactory clauseContextFactory;
        private ClauseQueryFactory clauseQueryFactory;
        private ClauseValidator clauseValidator;
        private ClausePermissionHandler permissionHandler;
        private final List<FieldIndexer> fieldIndexers;

        public SearchHandlerBuilder(ClauseInformation clauseInformation) {
            this.clauseContextFactory = (ClauseContextFactory)SearchHandlerBuilderFactory.this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
            this.fieldIndexers = Lists.newArrayList();
            this.clauseInformation = (ClauseInformation)Preconditions.checkNotNull((Object)clauseInformation);
        }

        public SearchHandlerBuilder setClauseQueryFactoryType(Class<? extends ClauseQueryFactory> clauseQueryFactoryType) {
            this.clauseQueryFactory = (ClauseQueryFactory)SearchHandlerBuilderFactory.this.locator.getComponent(clauseQueryFactoryType);
            return this;
        }

        public SearchHandlerBuilder setClauseValidatorType(Class<? extends ClauseValidator> clauseValidatorType) {
            this.clauseValidator = (ClauseValidator)SearchHandlerBuilderFactory.this.locator.getComponent(clauseValidatorType);
            return this;
        }

        public SearchHandlerBuilder setContextFactory(ClauseContextFactory classContextFactoryType) {
            this.clauseContextFactory = classContextFactoryType;
            return this;
        }

        public SearchHandlerBuilder setPermissionHandler(ClausePermissionHandler permissionHandler) {
            this.permissionHandler = permissionHandler;
            return this;
        }

        public SearchHandlerBuilder setPermissionChecker(ClausePermissionChecker permissionChecker) {
            this.permissionHandler = new DefaultClausePermissionHandler(permissionChecker);
            return this;
        }

        public SearchHandlerBuilder addIndexer(FieldIndexer indexer) {
            this.fieldIndexers.add(indexer);
            return this;
        }

        public SearchHandler buildWithValuesGenerator(ClauseValuesGenerator generator) {
            return this.withClauseHandler(new DefaultValuesGeneratingClauseHandler(this.clauseInformation, this.clauseQueryFactory, this.clauseValidator, this.permissionHandler, this.clauseContextFactory, generator));
        }

        public SearchHandler build() {
            return this.withClauseHandler(new DefaultClauseHandler(this.clauseInformation, this.clauseQueryFactory, this.clauseValidator, this.permissionHandler, this.clauseContextFactory));
        }

        private SearchHandler withClauseHandler(ClauseHandler clauseHandler) {
            Preconditions.checkState((this.clauseContextFactory != null ? 1 : 0) != 0);
            Preconditions.checkState((this.clauseValidator != null ? 1 : 0) != 0);
            Preconditions.checkState((this.permissionHandler != null ? 1 : 0) != 0);
            Preconditions.checkState((this.clauseQueryFactory != null ? 1 : 0) != 0);
            SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(clauseHandler);
            return new SearchHandler(this.fieldIndexers, null, Collections.singletonList(clauseRegistration));
        }
    }
}

