/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.permission.PermissionSchemeEntry;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionQueryFactory
implements PermissionQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionQueryFactory.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionTypeManager permissionTypeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager issueSecurityTypeManager;

    public DefaultPermissionQueryFactory(IssueSecurityLevelManager issueSecurityLevelManager, PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, PermissionTypeManager permissionTypeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager issueSecurityTypeManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionTypeManager = permissionTypeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecurityTypeManager = issueSecurityTypeManager;
    }

    @Override
    public Query getQuery(ApplicationUser searcher, ProjectPermissionKey permissionKey) {
        return this.createQuery(searcher, this.permissionManager.getProjects(permissionKey, searcher), permissionKey);
    }

    @Override
    public Query getQuery(ApplicationUser searcher, ProjectPermissionKey permissionKey, @Nonnull Collection<Project> searchedProjects) {
        List<Project> projects = searchedProjects.stream().filter(project -> this.permissionManager.hasPermission(permissionKey, project, searcher)).collect(Collectors.toList());
        return this.createQuery(searcher, projects, permissionKey);
    }

    private Query createQuery(ApplicationUser searcher, Collection<Project> projects, ProjectPermissionKey permissionKey) {
        try {
            LinkedHashSet<BytesRef> projectQueriesStrings = new LinkedHashSet<BytesRef>();
            for (Project project : projects) {
                this.collectProjectTerms(project, searcher, projectQueriesStrings, permissionKey);
            }
            if (!projectQueriesStrings.isEmpty()) {
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                query.add((Query)new TermInSetQuery("project_permissions", projectQueriesStrings), BooleanClause.Occur.FILTER);
                HashSet<BytesRef> securityLevels = new HashSet<BytesRef>();
                securityLevels.add(SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)-1L));
                try {
                    for (Project project : projects) {
                        this.collectSecurityLevelTerms(project, searcher, securityLevels);
                    }
                }
                catch (GenericEntityException e) {
                    log.error("Error occurred retrieving security levels for this user");
                }
                query.add((Query)new TermInSetQuery("issue_level_permissions", securityLevels), BooleanClause.Occur.FILTER);
                return query.build();
            }
            return new MatchNoDocsQuery("no permissions");
        }
        catch (GenericEntityException e) {
            log.error("Error constructing query: " + (Object)((Object)e), (Throwable)e);
            return null;
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new PermissionsFilterCache");
            }
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }

    void collectProjectTerms(@Nonnull Project project, ApplicationUser searcherUser, Set<BytesRef> queries, ProjectPermissionKey permissionId) throws GenericEntityException {
        Long schemeId = this.permissionSchemeManager.getSchemeIdFor(project);
        Collection permissionSchemeEntries = this.permissionSchemeManager.getPermissionSchemeEntries(schemeId.longValue(), permissionId);
        Map<Boolean, List<PermissionSchemeEntry>> permissions = permissionSchemeEntries.stream().filter(e -> this.permissionTypeManager.getSecurityType(e.getType()) != null).collect(Collectors.partitioningBy(e -> this.permissionTypeManager.getSecurityType(e.getType()).isTopLevelProjectPermission()));
        ImmutableList entities = ImmutableList.builder().addAll((Iterable)permissions.get(true)).addAll((Iterable)permissions.get(false)).build();
        for (PermissionSchemeEntry schemeEntry : entities) {
            SecurityType securityType = this.permissionTypeManager.getSecurityType(schemeEntry.getType());
            try {
                if (!this.userHasPermissionForProjectAndSecurityType(searcherUser, project, schemeEntry.getParameter(), securityType)) continue;
                Set<BytesRef> tempQuery = securityType.getPermissionFieldContents(searcherUser, project, schemeEntry.getParameter());
                queries.addAll(tempQuery);
                if (tempQuery.isEmpty() || !securityType.isTopLevelProjectPermission()) continue;
                break;
            }
            catch (Exception e2) {
                log.debug("Could not add query for security type:" + securityType.getDisplayName(), (Throwable)e2);
            }
        }
    }

    void collectSecurityLevelTerms(Project project, ApplicationUser searcherUser, Set<BytesRef> terms) throws GenericEntityException {
        List usersSecurityLevels = this.issueSecurityLevelManager.getUsersSecurityLevels(project, searcherUser);
        block0: for (IssueSecurityLevel securityLevel : usersSecurityLevels) {
            if (terms.contains(SecurityIndexingUtils.generateIssueLevelPermissionContents((Long)securityLevel.getId()))) continue;
            List permissionsForSecurityLevel = this.issueSecuritySchemeManager.getPermissionsBySecurityLevel(securityLevel.getId());
            Map<Boolean, List<IssueSecurityLevelPermission>> permissions = permissionsForSecurityLevel.stream().filter(e -> this.issueSecurityTypeManager.getSecurityType(e.getType()) != null).collect(Collectors.partitioningBy(e -> this.issueSecurityTypeManager.getSecurityType(e.getType()).isTopLevelIssueSecurityPermission()));
            ImmutableList securities = ImmutableList.builder().addAll((Iterable)permissions.get(true)).addAll((Iterable)permissions.get(false)).build();
            for (IssueSecurityLevelPermission securityLevelPermission : securities) {
                SecurityType securityType = this.issueSecurityTypeManager.getSecurityType(securityLevelPermission.getType());
                if (!this.userHasPermissionForProjectAndSecurityType(searcherUser, project, securityLevelPermission.getParameter(), securityType)) continue;
                Set<BytesRef> tempQuery = securityType.getPermissionFieldContents(searcherUser, project, securityLevel, securityLevelPermission.getParameter());
                terms.addAll(tempQuery);
                if (tempQuery.isEmpty() || !securityType.isTopLevelIssueSecurityPermission()) continue;
                continue block0;
            }
        }
    }

    boolean userHasPermissionForProjectAndSecurityType(ApplicationUser searcher, Project project, String parameter, SecurityType securityType) {
        boolean hasPermission = searcher == null ? securityType.hasPermission(project, parameter) : securityType.hasPermission(project, parameter, searcher, false);
        return hasPermission;
    }
}

