/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.LRUMap;
import org.apache.lucene.search.Query;

public class PermissionsFilterCache {
    private final Map cache = new LRUMap(50);

    public boolean hasQueryFor(ApplicationUser user, Collection<Project> projects) {
        return this.cache.containsKey(new CacheKey(user, projects));
    }

    public Query getQuery(ApplicationUser user, Collection<Project> projects) {
        return (Query)this.cache.get(new CacheKey(user, projects));
    }

    public void storeQuery(Query query, ApplicationUser user, Collection<Project> projects) {
        this.cache.put(new CacheKey(user, projects), query);
    }

    public void flush() {
        this.cache.clear();
    }

    private static class CacheKey {
        String username;
        Collection<Long> projectIds;

        public CacheKey(ApplicationUser searcher, Collection<Project> projects) {
            if (searcher != null) {
                this.username = searcher.getName();
            }
            if (projects != null) {
                this.projectIds = projects.stream().map(Project::getId).collect(Collectors.toList());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.username, cacheKey.username) && Objects.equals(this.projectIds, cacheKey.projectIds);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.projectIds);
        }
    }
}

