/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene;

import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsFilterGeneratorImpl
implements PermissionsFilterGenerator {
    private static final Logger log = LoggerFactory.getLogger(PermissionsFilterGeneratorImpl.class);
    private final PermissionQueryFactory permissionQueryFactory;

    public PermissionsFilterGeneratorImpl(PermissionQueryFactory permissionQueryFactory) {
        this.permissionQueryFactory = permissionQueryFactory;
    }

    public Query getQuery(ApplicationUser searcher) {
        return this.getQuery(searcher, (Collection<Project>)ImmutableList.of());
    }

    public Query getQuery(ApplicationUser searcher, @Nonnull Collection<Project> projects) {
        try (Ticker ignored = Timers.start((String)"Permission Query");){
            Query query = this.getCache().getQuery(searcher, projects);
            if (query == null) {
                query = projects.isEmpty() ? this.permissionQueryFactory.getQuery(searcher, ProjectPermissions.BROWSE_PROJECTS) : this.permissionQueryFactory.getQuery(searcher, ProjectPermissions.BROWSE_PROJECTS, projects);
                this.getCache().storeQuery(query, searcher, projects);
            }
            Query query2 = query;
            return query2;
        }
    }

    PermissionsFilterCache getCache() {
        PermissionsFilterCache cache = (PermissionsFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.permissions.filter.cache");
        if (cache == null) {
            log.debug("Creating new PermissionsFilterCache");
            cache = new PermissionsFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.permissions.filter.cache", cache);
        }
        return cache;
    }
}

