/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.lucene.sort;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.util.collect.MapBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class UserHistoryFieldComparatorSource
extends FieldComparatorSource {
    private final List<UserHistoryItem> history;

    public UserHistoryFieldComparatorSource(List<UserHistoryItem> history) {
        this.history = history;
    }

    public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        return new UserHistoryFieldComparator(numHits, this.history);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UserHistoryFieldComparatorSource that = (UserHistoryFieldComparatorSource)((Object)o);
        return this.history != null ? this.history.equals(that.history) : that.history == null;
    }

    public int hashCode() {
        return this.history != null ? this.history.hashCode() : 0;
    }

    public final class UserHistoryFieldComparator
    extends SimpleFieldComparator {
        private final Long[] values;
        private Long bottom;
        private final List<UserHistoryItem> history;
        private LeafReader reader = null;
        private Map<Integer, Long> docIdToTimestampMap;

        UserHistoryFieldComparator(int numHits, List<UserHistoryItem> history) {
            this.history = history;
            this.values = new Long[numHits];
        }

        public int compare(int slot1, int slot2) {
            Long v1 = this.values[slot1];
            Long v2 = this.values[slot2];
            if (v1 == null) {
                if (v2 == null) {
                    return 0;
                }
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return v1.compareTo(v2);
        }

        public int compareBottom(int doc) throws IOException {
            Long v2 = this.docIdToTimestampMap.get(doc);
            if (this.bottom == null) {
                if (v2 == null) {
                    return 0;
                }
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            return this.bottom.compareTo(v2);
        }

        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.docIdToTimestampMap.get(doc);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            LeafReader reader = context.reader();
            if (this.reader != reader) {
                this.reader = reader;
                this.docIdToTimestampMap = this.getIdToTimestampMap(this.reader, this.history);
            }
        }

        public void setTopValue(Object value) {
            throw new UnsupportedOperationException("IndexSearcher#searchAfter (deep paging) is not supported");
        }

        public int compareTop(int doc) throws IOException {
            throw new UnsupportedOperationException("IndexSearcher#searchAfter (deep paging) is not supported");
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        private Map<Integer, Long> getIdToTimestampMap(LeafReader reader, List<UserHistoryItem> history) throws IOException {
            MapBuilder builder = MapBuilder.newBuilder();
            for (UserHistoryItem item : history) {
                Integer docId = this.getDocIdForIssueId(reader, item.getEntityId());
                if (docId == null) continue;
                builder.add((Object)docId, (Object)item.getLastViewed());
            }
            return builder.toMap();
        }

        private Integer getDocIdForIssueId(LeafReader reader, String issueId) throws IOException {
            TermsEnum termsEnum;
            Bits liveDocs = reader.getLiveDocs();
            String indexField = SystemSearchConstants.forLastViewedDate().getIndexField();
            Terms terms = reader.terms(indexField);
            if (terms != null && (termsEnum = terms.iterator()).seekExact(new BytesRef((CharSequence)issueId))) {
                PostingsEnum postings = termsEnum.postings(null);
                while (postings.nextDoc() != Integer.MAX_VALUE) {
                    if (liveDocs != null && !liveDocs.get(postings.docID())) continue;
                    return postings.docID();
                }
            }
            return null;
        }

        public Comparable<?> value(int slot) {
            return null;
        }
    }
}

