/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.DescriptionIndexer;
import com.atlassian.jira.issue.index.indexers.impl.EnvironmentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SummaryIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.TextQuerySearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.TextQuerySearchInputTransformer;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class TextQuerySearcher
implements IssueSearcher<SearchableField> {
    private static final String ID = "text";
    private static final String NAME_KEY = "common.words.query";
    private static final List<Class<? extends FieldIndexer>> CLASSIC_FIELD_INDEXERS = CollectionBuilder.newBuilder((Object[])new Class[]{DescriptionIndexer.class, SummaryIndexer.class, EnvironmentIndexer.class}).asList();
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public TextQuerySearcher(JqlOperandResolver operandResolver, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine) {
        AtomicReference fieldRef = new AtomicReference();
        this.searcherInformation = new GenericSearcherInformation(ID, NAME_KEY, CLASSIC_FIELD_INDEXERS, fieldRef, SearcherGroupType.TEXT);
        this.searchInputTransformer = new TextQuerySearchInputTransformer(ID, (ClauseInformation)SystemSearchConstants.forAllText(), operandResolver);
        this.searchRenderer = new TextQuerySearchRenderer(ID, ID, NAME_KEY, velocityRequestContextFactory, applicationProperties, templatingEngine, this.searchInputTransformer);
    }

    public void init(SearchableField field) {
        throw new UnsupportedOperationException("This searcher not supposed to have a field");
    }

    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

