/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.comparator.ConstantsComparator;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.SearchContextRenderHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hsqldb.lib.StringUtil;
import webwork.action.Action;

public abstract class IssueConstantsSearchRenderer<T extends IssueConstant>
extends AbstractSearchRenderer
implements SearchRenderer {
    private final SimpleFieldSearchConstants constants;
    private final ConstantsManager constantsManager;
    private final FieldVisibilityManager fieldVisibilityManager;

    public IssueConstantsSearchRenderer(SimpleFieldSearchConstants constants, String searcherNameKey, ConstantsManager constantsManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, FieldVisibilityManager fieldVisibilityManager) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, constants, searcherNameKey);
        this.constants = constants;
        this.constantsManager = constantsManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public abstract Collection<T> getSelectListOptions(SearchContext var1);

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Object searcherNameKey;
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)this.constants.getUrlParameter());
        velocityParams.put("selectedValues", selectedValues);
        ArrayList<T> validSelectListOptions = new ArrayList<T>(this.getSelectListOptions(searchContext));
        SortedSet<T> invalidSelections = this.getInvalidSelections(selectedValues, validSelectListOptions, this.getAllSelectListOptions());
        velocityParams.put("invalidSelections", invalidSelections);
        if (!invalidSelections.isEmpty()) {
            SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
        }
        if ("navigator.filter.status".equals(searcherNameKey = velocityParams.get("searcherNameKey")) || "navigator.filter.matchingpriorities".equals(searcherNameKey)) {
            String maxOptionsNumber = (String)displayParameters.get("maxOptionsNumber");
            int limit = StringUtil.isEmpty((String)maxOptionsNumber) ? validSelectListOptions.size() : Integer.parseInt(maxOptionsNumber);
            velocityParams.put("limit", limit);
            int validSelectListOptionsCount = validSelectListOptions.size();
            velocityParams.put("selectListOptions", validSelectListOptionsCount > limit ? validSelectListOptions.subList(0, limit) : validSelectListOptions);
            velocityParams.put("totalListOptionsCount", validSelectListOptionsCount);
            return this.renderEditTemplate("status-searcher-edit.vm", velocityParams);
        }
        velocityParams.put("selectListOptions", validSelectListOptions);
        return this.renderEditTemplate("constants-searcher-edit.vm", velocityParams);
    }

    protected Collection<T> getAllSelectListOptions() {
        return this.getSelectListOptions(new SearchContextImpl(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
    }

    private SortedSet<T> getInvalidSelections(Collection<String> selectedKeys, Collection<T> validOptions, Collection<T> allOptions) {
        TreeSet<IssueConstant> invalidOptions = new TreeSet<IssueConstant>((Comparator<IssueConstant>)ConstantsComparator.COMPARATOR);
        HashSet<T> validOptionsSet = new HashSet<T>(validOptions);
        if (selectedKeys != null) {
            HashSet<String> selectedKeysSet = new HashSet<String>(selectedKeys);
            for (IssueConstant selectListOption : allOptions) {
                if (validOptionsSet.contains(selectListOption) || !selectedKeysSet.contains(selectListOption.getId())) continue;
                invalidOptions.add(selectListOption);
            }
        }
        return invalidOptions;
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, user);
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        Collection selectedValues = (Collection)fieldValuesHolder.get((Object)this.constants.getUrlParameter());
        SortedSet<T> invalidSelections = this.getInvalidSelections(selectedValues, this.getSelectListOptions(searchContext), this.getAllSelectListOptions());
        if (!invalidSelections.isEmpty()) {
            SearchContextRenderHelper.addSearchContextParams(searchContext, velocityParams);
        }
        ConstantsManager.CONSTANT_TYPE constantType = ConstantsManager.CONSTANT_TYPE.forTypeCaseInsensitive((String)this.constants.getUrlParameter());
        velocityParams.put("selectedObjects", this.constantsManager.getConstantsByIds(constantType, selectedValues));
        velocityParams.put("invalidSelections", invalidSelections);
        return this.renderViewTemplate("constants-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }
}

