/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.IssueLinkTypesClauseValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class IssueLinkTypesSearchInputTransformer
implements SearchInputTransformer {
    private final JqlOperandResolver operandResolver;
    private final IssueLinkTypesClauseValidator issueLinkTypesValidator;
    private final NavigatorStructureChecker<IssueLinkType> navigatorStructureChecker;

    public IssueLinkTypesSearchInputTransformer(FieldFlagOperandRegistry fieldFlagOperandRegistry, JqlOperandResolver operandResolver, IssueLinkTypesClauseValidator issueLinkTypesValidator) {
        this.operandResolver = operandResolver;
        this.issueLinkTypesValidator = issueLinkTypesValidator;
        this.navigatorStructureChecker = new NavigatorStructureChecker(IssueLinkTypesSearchInputTransformer.getJqlClauseNames(), false, fieldFlagOperandRegistry, operandResolver);
    }

    public void populateFromParams(ApplicationUser user, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        String url = IssueLinkTypesSearchInputTransformer.getUrlParameter();
        Optional.ofNullable(actionParams.getValuesForKey(url)).ifPresent(values -> fieldValuesHolder.put((Object)url, values));
    }

    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        Collection<String> linkTypes = this.getLinkTypes(fieldValuesHolder);
        if (linkTypes == null) {
            return;
        }
        this.issueLinkTypesValidator.validateInternal(linkTypes, arg_0 -> ((ErrorCollection)errors).addErrorMessage(arg_0), i18nHelper);
    }

    public void populateFromQuery(ApplicationUser user, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(IssueLinkTypesSearchInputTransformer.getJqlClauseNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)visitor);
        }
        List clauses = visitor.getClauses();
        if (!visitor.isValid() || clauses.isEmpty()) {
            return;
        }
        Set values = clauses.stream().flatMap(clause -> this.operandResolver.getValues(user, clause.getOperand(), clause).stream()).map(QueryLiteral::getStringValue).map(String::trim).collect(Collectors.toSet());
        fieldValuesHolder.put((Object)IssueLinkTypesSearchInputTransformer.getUrlParameter(), values);
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser user, Query query, SearchContext searchContext) {
        return this.navigatorStructureChecker.checkSearchRequest(query);
    }

    public Clause getSearchClause(ApplicationUser user, FieldValuesHolder fieldValuesHolder) {
        Collection<String> linkTypes = this.getLinkTypes(fieldValuesHolder);
        if (linkTypes == null || linkTypes.isEmpty()) {
            return null;
        }
        String primaryName = IssueLinkTypesSearchInputTransformer.getJqlClauseNames().getPrimaryName();
        if (linkTypes.size() == 1) {
            return new TerminalClauseImpl(primaryName, Operator.EQUALS, (Operand)new SingleValueOperand(((String)Iterables.getOnlyElement(linkTypes)).trim()));
        }
        Collection operands = linkTypes.stream().map(String::trim).map(SingleValueOperand::new).collect(Collectors.toList());
        return new TerminalClauseImpl(primaryName, Operator.IN, (Operand)new MultiValueOperand(operands));
    }

    private Collection<String> getLinkTypes(FieldValuesHolder fieldValuesHolder) {
        return (Collection)fieldValuesHolder.get((Object)IssueLinkTypesSearchInputTransformer.getUrlParameter());
    }

    private static ClauseNames getJqlClauseNames() {
        return SystemSearchConstants.forIssueLinkTypes().getJqlClauseNames();
    }

    private static String getUrlParameter() {
        return SystemSearchConstants.forIssueLinkTypes().getUrlParameter();
    }
}

