/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.customfields.converters.DateConverter;
import com.atlassian.jira.issue.customfields.converters.DateTimeConverter;
import com.atlassian.jira.issue.search.searchers.util.AbstractDateSearchInputHelper;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class DefaultDateSearcherInputHelper
extends AbstractDateSearchInputHelper {
    private final JqlDateSupport jqlDateSupport;
    private final DateConverter primaryDateConverter;
    private final DateTimeConverter dateTimeConverter;
    private final TimeZoneManager timeZoneManager;

    public DefaultDateSearcherInputHelper(DateSearcherConfig config, JqlOperandResolver operandResolver, JqlDateSupport jqlDateSupport, DateConverter primaryDateConverter, DateTimeConverter dateTimeConverter, TimeZoneManager timeZoneManager) {
        super(config, operandResolver);
        this.jqlDateSupport = (JqlDateSupport)Assertions.notNull((String)"jqlDateSupport", (Object)jqlDateSupport);
        this.primaryDateConverter = (DateConverter)Assertions.notNull((String)"primaryDateConverter", (Object)primaryDateConverter);
        this.dateTimeConverter = (DateTimeConverter)Assertions.notNull((String)"dateTimeConverter", (Object)dateTimeConverter);
        this.timeZoneManager = (TimeZoneManager)Assertions.notNull((String)"timeZoneManager", (Object)timeZoneManager);
    }

    protected AbstractDateSearchInputHelper.ParseDateResult getValidNavigatorDate(QueryLiteral dateLiteral, boolean allowTimeComponent) {
        Date date;
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = allowTimeComponent ? this.timeZoneManager.getLoggedInUserTimeZone() : this.timeZoneManager.getDefaultTimezone();
        if (dateLiteral.getLongValue() != null) {
            date = this.jqlDateSupport.convertToDate(dateLiteral.getLongValue());
            if (date == null) {
                return new AbstractDateSearchInputHelper.ParseDateResult(true, dateLiteral.getLongValue().toString());
            }
        } else if (StringUtils.isNotBlank((CharSequence)dateLiteral.getStringValue())) {
            date = this.jqlDateSupport.convertToDate(dateLiteral.getStringValue(), timeZone);
            if (date == null) {
                return new AbstractDateSearchInputHelper.ParseDateResult(true, dateLiteral.getStringValue());
            }
        } else {
            return null;
        }
        if (allowTimeComponent) {
            return new AbstractDateSearchInputHelper.ParseDateResult(true, this.dateTimeConverter.getString(date));
        }
        if (this.hasTimeComponent(date, timeZone)) {
            return new AbstractDateSearchInputHelper.ParseDateResult(false, this.dateTimeConverter.getString(date));
        }
        return new AbstractDateSearchInputHelper.ParseDateResult(true, this.primaryDateConverter.getString(date));
    }

    private boolean hasTimeComponent(Date date, TimeZone timeZone) {
        return JiraDateUtils.hasTimeComponent((Date)date, (TimeZone)timeZone);
    }
}

