/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelevantSearcherVisitor
implements ClauseVisitor<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(RelevantSearcherVisitor.class);
    private final Map<String, IssueSearcher> searchers = new HashMap<String, IssueSearcher>();
    private final ApplicationUser user;
    private final SearchHandlerManager searchHandlerManager;

    public RelevantSearcherVisitor(SearchHandlerManager searchHandlerManager, ApplicationUser user) {
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.user = user;
    }

    public Set<IssueSearcher> getRelevantSearchers() {
        return new HashSet<IssueSearcher>(this.searchers.values());
    }

    public Boolean visit(AndClause andClause) {
        return this.visitMultiClause((MultiClause)andClause);
    }

    public Boolean visit(NotClause notClause) {
        return (Boolean)notClause.getSubClause().accept((ClauseVisitor)this);
    }

    public Boolean visit(OrClause orClause) {
        return this.visitMultiClause((MultiClause)orClause);
    }

    public Boolean visit(TerminalClause clause) {
        IssueSearcher searcher = this.getSearcher(clause);
        if (searcher == null) {
            return false;
        }
        this.searchers.put(searcher.getSearchInformation().getId(), searcher);
        return true;
    }

    public Boolean visit(WasClause clause) {
        return false;
    }

    public Boolean visit(ChangedClause clause) {
        return false;
    }

    private boolean visitMultiClause(MultiClause multiClause) {
        boolean returnValue;
        Clause clause;
        Iterator iterator = multiClause.getClauses().iterator();
        for (returnValue = true; returnValue && iterator.hasNext(); returnValue &= ((Boolean)clause.accept((ClauseVisitor)this)).booleanValue()) {
            clause = (Clause)iterator.next();
        }
        return returnValue;
    }

    private IssueSearcher getSearcher(TerminalClause clause) {
        Collection searchersByClauseName = this.searchHandlerManager.getSearchersByClauseName(this.user, clause.getName());
        if (searchersByClauseName.size() == 1) {
            return (IssueSearcher)searchersByClauseName.iterator().next();
        }
        log.debug(String.format("Unable to resolve only one searcher for field '%s', found '%d' searchers", clause.getName(), searchersByClauseName.size()));
        return null;
    }
}

