/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.Query;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class SearchPropertiesManager {
    public static final String FILTER_ID_KEY = "user.search.filter.id";
    public static final String JQL_KEY = "user.search.jql";
    private static final Logger log = LoggerFactory.getLogger(SearchPropertiesManager.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SearchRequestService searchRequestService;
    private final SearchService searchService;
    private final UserPropertyManager userPropertyManager;

    public SearchPropertiesManager(JiraAuthenticationContext jiraAuthenticationContext, SearchRequestService searchRequestService, SearchService searchService, UserPropertyManager userPropertyManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.searchRequestService = searchRequestService;
        this.searchService = searchService;
        this.userPropertyManager = userPropertyManager;
    }

    public SearchRequest getSearchRequest() {
        SearchRequest searchRequest = null;
        if (this.getPropertySet() != null) {
            Query query;
            Long filterId = this.getFilterId();
            if (filterId != null) {
                ApplicationUser user = this.jiraAuthenticationContext.getUser();
                searchRequest = this.searchRequestService.getFilter((JiraServiceContext)new JiraServiceContextImpl(user), filterId);
            }
            if ((query = this.getJQLQuery()) != null) {
                if (searchRequest != null) {
                    searchRequest.setQuery(query);
                } else {
                    searchRequest = new SearchRequest(query);
                }
            }
        }
        return searchRequest;
    }

    public void setSearchRequest(SearchRequest searchRequest) {
        PropertySet propertySet = this.getPropertySet();
        if (propertySet == null) {
            return;
        }
        try {
            if (searchRequest != null) {
                Long filterId = searchRequest.getId();
                propertySet.setText(FILTER_ID_KEY, filterId != null ? filterId.toString() : null);
                String JQL = null;
                if (filterId == null || searchRequest.isModified()) {
                    JQL = this.searchService.getGeneratedJqlString(searchRequest.getQuery());
                }
                propertySet.setText(JQL_KEY, JQL);
            } else {
                if (propertySet.getText(FILTER_ID_KEY) != null) {
                    propertySet.setText(FILTER_ID_KEY, null);
                }
                if (propertySet.getText(JQL_KEY) != null) {
                    propertySet.setText(JQL_KEY, null);
                }
            }
        }
        catch (PropertyException e) {
            log.warn("Couldn't store a search request in user preferences.");
        }
    }

    private Long getFilterId() {
        String filterId = null;
        try {
            filterId = this.getPropertySet().getText(FILTER_ID_KEY);
        }
        catch (PropertyException e) {
            log.warn("Couldn't retrieve a filter ID from user properties.");
        }
        if (StringUtils.isNotEmpty((CharSequence)filterId)) {
            try {
                return Long.parseLong(filterId);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid filter ID in user preferences: " + filterId);
            }
        }
        return null;
    }

    private Query getJQLQuery() {
        ApplicationUser user;
        SearchService.ParseResult parseResult;
        String JQL = null;
        try {
            JQL = this.getPropertySet().getText(JQL_KEY);
        }
        catch (PropertyException e) {
            log.warn("Couldn't retrieve JQL from user properties.");
        }
        if (JQL != null && !JQL.isEmpty() && (parseResult = this.searchService.parseQuery(user = this.jiraAuthenticationContext.getUser(), JQL)).isValid()) {
            return parseResult.getQuery();
        }
        return null;
    }

    private PropertySet getPropertySet() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return user != null ? this.userPropertyManager.getPropertySet(user) : null;
    }
}

