/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.LabelsStatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.dbc.Assertions;

public class CustomFieldLabelsStatisticsMapper
extends LabelsStatisticsMapper
implements SearchRequestAppender.Factory {
    private CustomField customField;
    private CustomFieldInputHelper customFieldInputHelper;
    private final JiraAuthenticationContext authenticationContext;

    public CustomFieldLabelsStatisticsMapper(CustomField customField, CustomFieldInputHelper customFieldInputHelper, JiraAuthenticationContext authenticationContext, boolean includeEmpty) {
        super(JqlCustomFieldId.toString((long)customField.getIdAsLong()), customField.getId(), includeEmpty);
        this.customField = customField;
        this.customFieldInputHelper = customFieldInputHelper;
        this.authenticationContext = authenticationContext;
    }

    protected String getClauseName() {
        return this.customFieldInputHelper.getUniqueClauseName(this.authenticationContext.getUser(), this.customField.getClauseNames().getPrimaryName(), this.customField.getName());
    }

    @Deprecated
    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(value, searchRequest);
    }

    public SearchRequestAppender getSearchRequestAppender() {
        return new CustomFieldLabelsSearchRequestAppender(this.customField, this.getClauseName());
    }

    static class CustomFieldLabelsSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<Object>,
    SearchRequestAppender {
        private final CustomField customField;
        private final String clauseName;

        public CustomFieldLabelsSearchRequestAppender(CustomField customField, String clauseName) {
            this.customField = (CustomField)Assertions.notNull((Object)customField);
            this.clauseName = (String)Assertions.notNull((Object)clauseName);
        }

        public void appendNonNullItem(Object value, JqlClauseBuilder clauseBuilder) {
            clauseBuilder.customField(this.customField.getIdAsLong()).eq(value.toString());
        }

        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        public SearchRequest appendInclusiveSingleValueClause(Object value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause((Object)value, (SearchRequest)searchRequest, (SearchRequestAddendumBuilder.AddendumCallback)this);
        }

        public SearchRequest appendExclusiveMultiValueClause(Iterable values, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses((Iterable)values, (SearchRequest)searchRequest, (SearchRequestAddendumBuilder.AddendumCallback)this);
        }
    }
}

