/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status.category;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.function.issue.UpdateIssueFieldFunction;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCategoryMapper {
    private static final Logger log = LoggerFactory.getLogger(StatusCategoryMapper.class);
    private StatusCategoryManager statusCategoryManager;

    public StatusCategoryMapper(StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = statusCategoryManager;
    }

    public Map<String, StatusCategory> mapCategoriesToStatuses(JiraWorkflow workflow) {
        Assertions.notNull((String)"workflow", (Object)workflow);
        HashMap map = Maps.newHashMap();
        try {
            List statuses = workflow.getLinkedStatusObjects();
            for (Status status : statuses) {
                if (null == status) continue;
                map.put(status.getId(), this.getDefaultCategory());
            }
        }
        catch (RuntimeException e) {
            log.error(String.format("The '%s' workflow is misconfigured", workflow.getName()), (Throwable)e);
        }
        try {
            Status status;
            StepDescriptor step = StatusCategoryMapper.getInitialStepDescriptor(workflow);
            if (null != step && null != (status = workflow.getLinkedStatusObject(step))) {
                map.put(status.getId(), this.getStartingCategory());
            }
        }
        catch (RuntimeException e) {
            log.error(String.format("Failed to determine the initial step for '%s' workflow ", workflow.getName()), (Throwable)e);
        }
        try {
            for (ActionDescriptor actionDescriptor : workflow.getAllActions()) {
                List postFunctions = actionDescriptor.getUnconditionalResult().getPostFunctions();
                for (FunctionDescriptor descriptor : postFunctions) {
                    String className = (String)descriptor.getArgs().get("class.name");
                    String fieldName = (String)descriptor.getArgs().get("field.name");
                    String fieldValue = (String)descriptor.getArgs().get("field.value");
                    if (!StringUtils.equals((CharSequence)className, (CharSequence)UpdateIssueFieldFunction.class.getName()) || !StringUtils.equals((CharSequence)fieldName, (CharSequence)"resolution") || !StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
                    StepDescriptor stepDescriptor = workflow.getDescriptor().getStep(actionDescriptor.getUnconditionalResult().getStep());
                    Status destinationStatus = workflow.getLinkedStatusObject(stepDescriptor);
                    map.put(destinationStatus.getId(), this.getCompleteCategory());
                }
            }
        }
        catch (RuntimeException e) {
            log.error(String.format("Failed to find completion steps for '%s' workflow", workflow.getName()), (Throwable)e);
        }
        return map;
    }

    private static StepDescriptor getInitialStepDescriptor(JiraWorkflow workflow) {
        List initialActions = workflow.getDescriptor().getInitialActions();
        ActionDescriptor initialAction = (ActionDescriptor)initialActions.get(0);
        int initialStep = initialAction.getUnconditionalResult().getStep();
        return workflow.getDescriptor().getStep(initialStep);
    }

    private StatusCategory getDefaultCategory() {
        return this.statusCategoryManager.getStatusCategoryByKey("indeterminate");
    }

    private StatusCategory getStartingCategory() {
        return this.statusCategoryManager.getStatusCategoryByKey("new");
    }

    private StatusCategory getCompleteCategory() {
        return this.statusCategoryManager.getStatusCategoryByKey("done");
    }
}

