/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util.streamingretrievers;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslUtils;
import com.atlassian.jira.issue.util.streamingretrievers.BaseStreamingRetriever;
import com.atlassian.jira.model.querydsl.ProjectDTO;
import com.atlassian.jira.model.querydsl.QProject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class StreamingProjectDTORetriever
extends BaseStreamingRetriever<Long, String, ProjectDTO> {
    private final QueryDslAccessor qdslAccessor;
    private final DatabaseAccessor dbAccessor;

    public StreamingProjectDTORetriever(QueryDslAccessor qdslAccessor, DatabaseAccessor dbAccessor) {
        this.qdslAccessor = qdslAccessor;
        this.dbAccessor = dbAccessor;
    }

    @Override
    public Stream<List<ProjectDTO>> stream(String descriptionSubstring, int batchSize) {
        return super.stream(descriptionSubstring, batchSize);
    }

    @Override
    protected List<Long> getEntityIds(String descriptionSubstring) {
        return this.qdslAccessor.executeQuery(con -> ((SQLQuery)((SQLQuery)((SQLQuery)con.newSqlQuery().select(QProject.PROJECT.id).from((Expression)QProject.PROJECT)).where((Predicate)QueryDslUtils.safeContainsIgnoreCase(this.dbAccessor.getDatabaseVendor(), QProject.PROJECT.description, descriptionSubstring))).orderBy(QProject.PROJECT.id.asc())).fetch());
    }

    @Override
    protected List<ProjectDTO> getEntitiesBatchByIds(List<Long> idsBatch) {
        return this.qdslAccessor.executeQuery(con -> ((SQLQuery)((SQLQuery)con.newSqlQuery().select((Expression)QProject.PROJECT).from((Expression)QProject.PROJECT)).where((Predicate)QProject.PROJECT.id.in((Collection)idsBatch))).fetch());
    }
}

