/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Objects;

public class WorklogImpl2
implements Worklog {
    private final Long id;
    private final String authorKey;
    private final String updateAuthorKey;
    private final String comment;
    private final String groupLevel;
    private final Long roleLevelId;
    private final Date created;
    private final Date updated;
    private final Date startDate;
    private final Long timeSpent;
    private final Issue issue;
    private final ProjectRole projectRole;

    public WorklogImpl2(Issue issue, Long id, String authorKey, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent, ProjectRole projectRole) {
        this(issue, id, authorKey, comment, startDate, groupLevel, roleLevelId, timeSpent, authorKey, new Date(), null, projectRole);
    }

    public WorklogImpl2(Issue issue, Long id, String authorKey, String comment, Date startDate, String groupLevel, Long roleLevelId, Long timeSpent, String updateAuthorKey, Date created, Date updated, ProjectRole projectRole) {
        this.checkTimeSpent(timeSpent);
        this.authorKey = authorKey;
        if (updateAuthorKey == null) {
            updateAuthorKey = this.authorKey;
        }
        this.updateAuthorKey = updateAuthorKey;
        this.comment = comment;
        this.groupLevel = groupLevel;
        this.roleLevelId = roleLevelId;
        this.timeSpent = timeSpent;
        Date createdDate = JiraDateUtils.copyOrCreateDateNullsafe((Date)created);
        this.startDate = startDate == null ? createdDate : startDate;
        this.created = createdDate;
        this.updated = updated == null ? createdDate : updated;
        this.issue = issue;
        this.id = id;
        this.projectRole = projectRole;
    }

    private void checkTimeSpent(Long timeSpent) {
        Preconditions.checkArgument((timeSpent != null ? 1 : 0) != 0, (Object)"timeSpent must be set!");
    }

    public Long getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.authorKey;
    }

    public String getAuthorFullName() {
        ApplicationUser user = this.getAuthorObject();
        if (user != null) {
            return user.getDisplayName();
        }
        return this.authorKey;
    }

    public String getUpdateAuthor() {
        return this.updateAuthorKey;
    }

    public String getUpdateAuthorFullName() {
        ApplicationUser user = this.getUpdateAuthorObject();
        if (user != null) {
            return user.getDisplayName();
        }
        return this.updateAuthorKey;
    }

    public String getAuthorKey() {
        return this.authorKey;
    }

    public ApplicationUser getAuthorObject() {
        return WorkflowFunctionUtils.getUserByKey((String)this.authorKey);
    }

    public String getUpdateAuthorKey() {
        return this.updateAuthorKey;
    }

    public ApplicationUser getUpdateAuthorObject() {
        return WorkflowFunctionUtils.getUserByKey((String)this.updateAuthorKey);
    }

    public Date getStartDate() {
        return JiraDateUtils.copyDateNullsafe((Date)this.startDate);
    }

    public Long getTimeSpent() {
        return this.timeSpent;
    }

    public String getGroupLevel() {
        return this.groupLevel;
    }

    public Long getRoleLevelId() {
        return this.roleLevelId;
    }

    public ProjectRole getRoleLevel() {
        return this.projectRole;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorklogImpl2 that = (WorklogImpl2)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.authorKey, that.authorKey) && Objects.equals(this.updateAuthorKey, that.updateAuthorKey) && Objects.equals(this.comment, that.comment) && Objects.equals(this.groupLevel, that.groupLevel) && Objects.equals(this.roleLevelId, that.roleLevelId) && Objects.equals(this.created, that.created) && Objects.equals(this.updated, that.updated) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.timeSpent, that.timeSpent) && Objects.equals(this.issue, that.issue) && Objects.equals(this.projectRole, that.projectRole);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.authorKey, this.updateAuthorKey, this.comment, this.groupLevel, this.roleLevelId, this.created, this.updated, this.startDate, this.timeSpent, this.issue, this.projectRole);
    }

    public String toString() {
        return "WorklogImpl2{id=" + this.id + ", authorKey='" + this.authorKey + '\'' + ", updateAuthorKey='" + this.updateAuthorKey + '\'' + ", comment='" + this.comment + '\'' + ", groupLevel='" + this.groupLevel + '\'' + ", roleLevelId=" + this.roleLevelId + ", created=" + this.created + ", updated=" + this.updated + ", startDate=" + this.startDate + ", timeSpent=" + this.timeSpent + ", issue=" + this.issue + ", projectRole=" + this.projectRole + '}';
    }
}

