/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.BuilderOperator;
import com.atlassian.jira.jql.builder.MutableClause;
import com.atlassian.jira.jql.builder.SimpleClauseBuilder;
import com.atlassian.jira.jql.builder.SingleMutableClause;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@NotThreadSafe
class PrecedenceSimpleClauseBuilder
implements SimpleClauseBuilder {
    private final Stacks stacks;
    private BuilderState builderState;
    private BuilderOperator defaultOperator;

    PrecedenceSimpleClauseBuilder() {
        this.stacks = new Stacks();
        this.builderState = StartState.INSTANCE.enter(this.stacks);
        this.defaultOperator = null;
    }

    PrecedenceSimpleClauseBuilder(PrecedenceSimpleClauseBuilder copy) {
        this.builderState = IllegalState.INSTANCE;
        this.stacks = new Stacks(copy.stacks);
        this.builderState = copy.builderState.copy(this.stacks);
        this.defaultOperator = copy.defaultOperator;
    }

    @Override
    public SimpleClauseBuilder copy() {
        return new PrecedenceSimpleClauseBuilder(this);
    }

    @Override
    public SimpleClauseBuilder defaultAnd() {
        this.defaultOperator = BuilderOperator.AND;
        return this;
    }

    @Override
    public SimpleClauseBuilder defaultOr() {
        this.defaultOperator = BuilderOperator.OR;
        return this;
    }

    @Override
    public SimpleClauseBuilder defaultNone() {
        this.defaultOperator = null;
        return this;
    }

    @Override
    public SimpleClauseBuilder clear() {
        this.defaultOperator = null;
        this.stacks.clear();
        this.builderState = StartState.INSTANCE.enter(this.stacks);
        return this;
    }

    @Override
    public SimpleClauseBuilder and() {
        this.builderState = this.builderState.and(this.stacks).enter(this.stacks);
        return this;
    }

    @Override
    public SimpleClauseBuilder or() {
        this.builderState = this.builderState.or(this.stacks).enter(this.stacks);
        return this;
    }

    @Override
    public SimpleClauseBuilder not() {
        this.builderState = this.builderState.not(this.stacks, this.defaultOperator).enter(this.stacks);
        return this;
    }

    @Override
    public PrecedenceSimpleClauseBuilder clause(Clause clause) {
        Assertions.notNull((String)"clause", (Object)clause);
        this.builderState = this.builderState.add(this.stacks, new SingleMutableClause(clause), this.defaultOperator).enter(this.stacks);
        return this;
    }

    @Override
    public SimpleClauseBuilder sub() {
        this.builderState = this.builderState.group(this.stacks, this.defaultOperator).enter(this.stacks);
        return this;
    }

    @Override
    public SimpleClauseBuilder endsub() {
        this.builderState = this.builderState.endgroup(this.stacks).enter(this.stacks);
        return this;
    }

    @Override
    public Clause build() {
        return this.builderState.build(this.stacks);
    }

    public String toString() {
        return this.stacks.getDisplayString();
    }

    private static class OperatorVisitor
    implements ClauseVisitor<BuilderOperator> {
        private OperatorVisitor() {
        }

        static BuilderOperator findOperator(Clause clause) {
            OperatorVisitor visitor = new OperatorVisitor();
            return (BuilderOperator)((Object)clause.accept((ClauseVisitor)visitor));
        }

        public BuilderOperator visit(AndClause andClause) {
            return BuilderOperator.AND;
        }

        public BuilderOperator visit(NotClause notClause) {
            return BuilderOperator.NOT;
        }

        public BuilderOperator visit(OrClause orClause) {
            return BuilderOperator.OR;
        }

        public BuilderOperator visit(TerminalClause clause) {
            return null;
        }

        public BuilderOperator visit(WasClause clause) {
            return null;
        }

        public BuilderOperator visit(ChangedClause clause) {
            return null;
        }
    }

    private static class InfiniteReversedIterator<T>
    implements Iterator<T> {
        private ListIterator<T> delegate;

        public InfiniteReversedIterator(ListIterator<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            if (this.delegate.hasPrevious()) {
                return this.delegate.previous();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IllegalState
    implements BuilderState {
        private static final IllegalState INSTANCE = new IllegalState();

        private IllegalState() {
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            throw new IllegalStateException("Trying to access builder in illegal state.");
        }

        @Override
        public BuilderState and(Stacks stacks) {
            throw new IllegalStateException("Trying to add 'AND' to builder before it has been initialised.");
        }

        @Override
        public BuilderState or(Stacks stacks) {
            throw new IllegalStateException("Trying to add 'OR' to builder before it has been initialised.");
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            throw new IllegalStateException("Trying to add clause to builder before it has been initialised.");
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            throw new IllegalStateException("Trying to start sub-clause in a builder that has not been initialised.");
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            throw new IllegalStateException("Trying to end sub-clause in a builder that has not been initialised.");
        }

        @Override
        public Clause build(Stacks stacks) {
            throw new IllegalStateException("Trying to call build before the builder is initialised.");
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            throw new IllegalStateException("Trying to copy a builder that has not been initialised.");
        }

        public String toString() {
            return "Illegal State";
        }
    }

    private static class StartGroup
    implements BuilderState {
        static final StartGroup INSTANCE = new StartGroup();

        private StartGroup() {
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            stacks.processAndPush(BuilderOperator.LPAREN);
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            return NotState.INSTANCE;
        }

        @Override
        public BuilderState and(Stacks stacks) {
            throw new IllegalStateException("Trying to start sub-expression with 'AND'. Current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState or(Stacks stacks) {
            throw new IllegalStateException("Trying to start sub-expression with 'OR'. Current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            stacks.pushOperand(clause);
            return OperatorState.INSTANCE;
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            return this;
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            throw new IllegalStateException("Trying to create empty sub-expression. Current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public Clause build(Stacks stacks) {
            throw new IllegalStateException("Tyring to build JQL expression that has an incomplete sub-expression. The current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class ClauseState
    implements BuilderState {
        private final BuilderOperator lastOperator;

        public ClauseState(BuilderOperator lastOperator) {
            this.lastOperator = lastOperator;
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            return NotState.INSTANCE;
        }

        @Override
        public BuilderState and(Stacks stacks) {
            throw new IllegalStateException(String.format("Trying to create illegal JQL expression '%s %s'. Current JQL is '%s'.", new Object[]{this.lastOperator, BuilderOperator.AND, stacks.getDisplayString()}));
        }

        @Override
        public BuilderState or(Stacks stacks) {
            throw new IllegalStateException(String.format("Trying to create illegal JQL expression '%s %s'. Current JQL is '%s'.", new Object[]{this.lastOperator, BuilderOperator.OR, stacks.getDisplayString()}));
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            stacks.pushOperand(clause);
            return OperatorState.INSTANCE;
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            return StartGroup.INSTANCE;
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            throw new IllegalStateException(String.format("Trying to create illegal JQL expression '%s %s'. Current JQL is '%s'.", new Object[]{this.lastOperator, BuilderOperator.RPAREN, stacks.getDisplayString()}));
        }

        @Override
        public Clause build(Stacks stacks) {
            throw new IllegalStateException(String.format("Trying end the JQL expression with operator '%s'. Current JQL is '%s'.", new Object[]{this.lastOperator, stacks.getDisplayString()}));
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class OperatorState
    implements BuilderState {
        static final OperatorState INSTANCE = new OperatorState();

        private OperatorState() {
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            if (defaultOperator == null) {
                throw new IllegalStateException("Trying to combine JQL expressions using the 'NOT' operator. The current JQL is '" + stacks.getDisplayString() + "'.");
            }
            stacks.processAndPush(defaultOperator);
            return NotState.INSTANCE;
        }

        @Override
        public BuilderState and(Stacks stacks) {
            stacks.processAndPush(BuilderOperator.AND);
            return new ClauseState(BuilderOperator.AND);
        }

        @Override
        public BuilderState or(Stacks stacks) {
            stacks.processAndPush(BuilderOperator.OR);
            return new ClauseState(BuilderOperator.OR);
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            if (defaultOperator == null) {
                throw new IllegalStateException("Trying to combine JQL expressions without logical operator. The current JQL is '" + stacks.getDisplayString() + "'.");
            }
            stacks.processAndPush(defaultOperator);
            stacks.pushOperand(clause);
            return this;
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            if (defaultOperator == null) {
                throw new IllegalStateException("Trying to combine JQL expressions without logical operator. The current JQL is '" + stacks.getDisplayString() + "'.");
            }
            stacks.processAndPush(defaultOperator);
            return StartGroup.INSTANCE;
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            if (stacks.getLevel() == 0) {
                throw new IllegalStateException("Tyring end JQL sub-expression that does not exist. The current JQL is '" + stacks.getDisplayString() + "'.");
            }
            stacks.processAndPush(BuilderOperator.RPAREN);
            return this;
        }

        @Override
        public Clause build(Stacks stacks) {
            if (stacks.getLevel() > 0) {
                throw new IllegalStateException("Tyring to build JQL expression that has an incomplete sub-expression. The current JQL is '" + stacks.getDisplayString() + "'.");
            }
            Stacks localStacks = new Stacks(stacks);
            return localStacks.asClause();
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class NotState
    implements BuilderState {
        static final NotState INSTANCE = new NotState();

        private NotState() {
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            stacks.processAndPush(BuilderOperator.NOT);
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            return this;
        }

        @Override
        public BuilderState and(Stacks stacks) {
            throw new IllegalStateException("Trying to create the illegal JQL expression 'NOT AND'. The current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState or(Stacks stacks) {
            throw new IllegalStateException("Trying to create the illegal JQL expression 'NOT OR'. The current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            stacks.pushOperand(clause);
            return OperatorState.INSTANCE;
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            return StartGroup.INSTANCE;
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            throw new IllegalStateException("Tying to end JQL sub-expression without completing 'NOT' operator. The current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public Clause build(Stacks stacks) {
            throw new IllegalStateException("Trying to end JQL expression with the 'NOT' operator. The current JQL is '" + stacks.getDisplayString() + "'.");
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class StartState
    implements BuilderState {
        static final StartState INSTANCE = new StartState();

        private StartState() {
        }

        @Override
        public BuilderState enter(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState not(Stacks stacks, BuilderOperator defaultOperator) {
            return NotState.INSTANCE;
        }

        @Override
        public BuilderState and(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState or(Stacks stacks) {
            return this;
        }

        @Override
        public BuilderState add(Stacks stacks, MutableClause clause, BuilderOperator defaultOperator) {
            stacks.pushOperand(clause);
            return OperatorState.INSTANCE;
        }

        @Override
        public BuilderState group(Stacks stacks, BuilderOperator defaultOperator) {
            return StartGroup.INSTANCE;
        }

        @Override
        public BuilderState endgroup(Stacks stacks) {
            throw new IllegalStateException("Tying to start JQL expression with ')'.");
        }

        @Override
        public Clause build(Stacks stacks) {
            return null;
        }

        @Override
        public BuilderState copy(Stacks stacks) {
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static interface BuilderState {
        public BuilderState enter(Stacks var1);

        public BuilderState not(Stacks var1, BuilderOperator var2);

        public BuilderState and(Stacks var1);

        public BuilderState or(Stacks var1);

        public BuilderState add(Stacks var1, MutableClause var2, BuilderOperator var3);

        public BuilderState group(Stacks var1, BuilderOperator var2);

        public BuilderState endgroup(Stacks var1);

        public Clause build(Stacks var1);

        public BuilderState copy(Stacks var1);
    }

    private static final class Stacks {
        private final List<BuilderOperator> operators;
        private final List<MutableClause> operands;
        private int level = 0;

        Stacks() {
            this.operators = new LinkedList<BuilderOperator>();
            this.operands = new LinkedList<MutableClause>();
        }

        Stacks(Stacks state) {
            this.operators = new LinkedList<BuilderOperator>(state.operators);
            this.operands = new LinkedList<MutableClause>();
            this.level = state.level;
            for (MutableClause operand : state.operands) {
                this.operands.add(operand.copy());
            }
        }

        void clear() {
            this.operands.clear();
            this.operators.clear();
            this.level = 0;
        }

        int getLevel() {
            return this.level;
        }

        BuilderOperator popOperator() {
            BuilderOperator builderOperator = this.operators.remove(0);
            if (builderOperator == BuilderOperator.LPAREN) {
                --this.level;
            }
            return builderOperator;
        }

        BuilderOperator peekOperator() {
            return this.operators.get(0);
        }

        boolean hasOperator() {
            return !this.operators.isEmpty();
        }

        void pushOperand(MutableClause operand) {
            this.operands.add(0, operand);
        }

        MutableClause popClause() {
            return this.operands.remove(0);
        }

        MutableClause peekClause() {
            return this.operands.get(0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void processAndPush(BuilderOperator operator) {
            if (operator != BuilderOperator.LPAREN && this.hasOperator()) {
                int compare;
                BuilderOperator currentTop = this.peekOperator();
                int n = compare = operator == BuilderOperator.NOT ? -1 : 0;
                while (currentTop != null && (operator == null || operator.compareTo(currentTop) <= compare)) {
                    MutableClause rightOperand;
                    MutableClause leftOperand;
                    this.popOperator();
                    if (currentTop == BuilderOperator.NOT) {
                        leftOperand = this.popClause();
                        rightOperand = null;
                    } else {
                        rightOperand = this.popClause();
                        leftOperand = this.popClause();
                    }
                    this.pushOperand(leftOperand.combine(currentTop, rightOperand));
                    if (this.hasOperator()) {
                        currentTop = this.peekOperator();
                        continue;
                    }
                    currentTop = null;
                }
            }
            if (operator == null) return;
            if (operator == BuilderOperator.RPAREN) {
                if (!this.hasOperator() || this.peekOperator() != BuilderOperator.LPAREN) throw new IllegalStateException("The ')' does not have a matching '('.");
                this.popOperator();
                return;
            } else {
                if (operator == BuilderOperator.LPAREN) {
                    ++this.level;
                }
                this.operators.add(0, operator);
            }
        }

        String getDisplayString() {
            InfiniteReversedIterator<BuilderOperator> operatorIterator = new InfiniteReversedIterator<BuilderOperator>(this.operators.listIterator(this.operators.size()));
            InfiniteReversedIterator<MutableClause> clauseIterator = new InfiniteReversedIterator<MutableClause>(this.operands.listIterator(this.operands.size()));
            StringBuilder stringBuilder = new StringBuilder();
            boolean start = true;
            BuilderOperator operator = (BuilderOperator)((Object)operatorIterator.next());
            while (operator != null) {
                switch (operator) {
                    case LPAREN: {
                        Stacks.addString(stringBuilder, "(");
                        operator = (BuilderOperator)((Object)operatorIterator.next());
                        start = true;
                        break;
                    }
                    case RPAREN: {
                        stringBuilder.append(")");
                        operator = (BuilderOperator)((Object)operatorIterator.next());
                        start = false;
                        break;
                    }
                    case AND: 
                    case OR: {
                        if (start) {
                            Stacks.addString(stringBuilder, Stacks.clauseToString((MutableClause)clauseIterator.next(), operator));
                        }
                    }
                    case NOT: {
                        Stacks.addString(stringBuilder, operator.toString());
                        BuilderOperator nextOperator = (BuilderOperator)((Object)operatorIterator.next());
                        if (nextOperator != BuilderOperator.LPAREN && nextOperator != BuilderOperator.NOT) {
                            Stacks.addString(stringBuilder, Stacks.clauseToString((MutableClause)clauseIterator.next(), operator));
                        }
                        start = false;
                        operator = nextOperator;
                    }
                }
            }
            MutableClause clause = (MutableClause)clauseIterator.next();
            while (clause != null) {
                Stacks.addString(stringBuilder, Stacks.clauseToString(clause, null));
                clause = (MutableClause)clauseIterator.next();
            }
            return stringBuilder.toString();
        }

        private static void addString(StringBuilder builder, String append) {
            if (append.length() == 0) {
                return;
            }
            int length = builder.length();
            if (length != 0 && builder.charAt(length - 1) != '(') {
                builder.append(" ");
            }
            builder.append(append);
        }

        private static String clauseToString(MutableClause clause, BuilderOperator operator) {
            if (clause == null) {
                return "";
            }
            Clause jqlClause = clause.asClause();
            if (jqlClause == null) {
                return "";
            }
            BuilderOperator clauseOperator = OperatorVisitor.findOperator(jqlClause);
            if (operator != null && clauseOperator != null && operator.compareTo(clauseOperator) > 0) {
                return "(" + jqlClause.toString() + ")";
            }
            return jqlClause.toString();
        }

        Clause asClause() {
            return this.asMutableClause().asClause();
        }

        MutableClause asMutableClause() {
            this.processAndPush(null);
            return this.peekClause();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

