/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueIdJoinQueryFactory;
import com.atlassian.jira.jql.query.LikeQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.QueryProjectRoleAndGroupPermissionsDecorator;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(CommentClauseQueryFactory.class);
    private final IssueIdJoinQueryFactory issueIdJoinQueryFactory;
    private final QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator;
    private final LuceneQueryModifier luceneQueryModifier;
    private final ClauseQueryFactory delegateClauseQueryFactory;

    public CommentClauseQueryFactory(IssueIdJoinQueryFactory issueIdJoinQueryFactory, QueryProjectRoleAndGroupPermissionsDecorator queryPermissionsDecorator, LuceneQueryModifier luceneQueryModifier, JqlOperandResolver operandResolver) {
        this.issueIdJoinQueryFactory = issueIdJoinQueryFactory;
        this.queryPermissionsDecorator = queryPermissionsDecorator;
        this.luceneQueryModifier = luceneQueryModifier;
        this.delegateClauseQueryFactory = this.getDelegate(operandResolver);
    }

    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        if (!this.isClauseValid(terminalClause)) {
            return QueryFactoryResult.createFalseResult();
        }
        Query query = this.luceneQueryModifier.getModifiedQuery(this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause).getLuceneQuery());
        Query queryWithPermissionFilter = this.queryPermissionsDecorator.appendPermissionFilterQuery(query, queryCreationContext, "level", "role_level");
        Query issueIdFilterQuery = this.issueIdJoinQueryFactory.createIssueIdJoinQuery(queryWithPermissionFilter, "comments");
        return new QueryFactoryResult(issueIdFilterQuery);
    }

    ClauseQueryFactory getDelegate(JqlOperandResolver jqlOperandResolver) {
        ArrayList<LikeQueryFactory> operatorFactories = new ArrayList<LikeQueryFactory>();
        operatorFactories.add(new LikeQueryFactory(false));
        return new GenericClauseQueryFactory("body", operatorFactories, jqlOperandResolver);
    }

    boolean isClauseValid(TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!Operator.LIKE.equals((Object)operator) && !Operator.NOT_LIKE.equals((Object)operator)) {
            log.debug("Can not generate a comment clause query for a clause with operator '" + operator.getDisplayString() + "'.");
            return false;
        }
        return true;
    }
}

