/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.SearchProviderFactory;
import java.io.IOException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueIdJoinQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(IssueIdJoinQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;

    public IssueIdJoinQueryFactory(SearchProviderFactory searchProviderFactory) {
        this.searchProviderFactory = searchProviderFactory;
    }

    public Query createIssueIdJoinQuery(Query indexQuery, String indexName) {
        try {
            return JoinUtil.createJoinQuery((String)"issue_id", (boolean)false, (String)"issue_id", (Query)indexQuery, (IndexSearcher)this.searchProviderFactory.getSearcher(indexName), (ScoreMode)ScoreMode.Avg);
        }
        catch (IOException e) {
            log.error("Unable to search the " + indexName + " index.", (Throwable)e);
            return new MatchNoDocsQuery();
        }
    }
}

