/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.link.JqlSearchIssueLinkTypeEvent;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.EqualityWithSpecifiedEmptyValueQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IssueLinkTypesIndexInfoResolver;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class IssueLinkTypesClauseQueryFactory
implements ClauseQueryFactory {
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final JqlOperandResolver jqlOperandResolver;

    public IssueLinkTypesClauseQueryFactory(JqlOperandResolver jqlOperandResolver, IssueLinkTypeManager issueLinkTypeManager, String fieldId) {
        EqualityWithSpecifiedEmptyValueQueryFactory<IssueLinkType> operatorFactory = new EqualityWithSpecifiedEmptyValueQueryFactory<IssueLinkType>(new IssueLinkTypesIndexInfoResolver(issueLinkTypeManager), "-1");
        this.delegateClauseQueryFactory = new GenericClauseQueryFactory(fieldId, Collections.singletonList(operatorFactory), jqlOperandResolver);
        this.jqlOperandResolver = jqlOperandResolver;
    }

    @Nonnull
    public QueryFactoryResult getQuery(@Nonnull QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        this.signalUsage(queryCreationContext, terminalClause);
        return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
    }

    private void signalUsage(QueryCreationContext queryCreationContext, @Nonnull TerminalClause terminalClause) {
        ((EventPublisher)ComponentAccessor.getComponent(EventPublisher.class)).publish((Object)new JqlSearchIssueLinkTypeEvent(terminalClause.getOperator().name(), this.resolveValues(queryCreationContext, terminalClause)));
    }

    private List<String> resolveValues(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        return this.jqlOperandResolver.getValues(queryCreationContext, terminalClause.getOperand(), terminalClause).stream().filter(v -> !v.isEmpty()).map(QueryLiteral::asString).collect(Collectors.toList());
    }
}

