/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolutionIndexInfoResolver
extends IssueConstantInfoResolver<Resolution> {
    public static final String UNRESOLVED_OPERAND = "unresolved";
    public static final String QUOTED_UNRESOLVED_VALUE = "\"unresolved\"";

    public ResolutionIndexInfoResolver(NameResolver<Resolution> resolutionNameResolver) {
        super(resolutionNameResolver);
    }

    @Override
    public List<String> getIndexedValues(String singleValueOperand) {
        if (ResolutionIndexInfoResolver.isUnresolvedOperand(singleValueOperand)) {
            return Collections.singletonList("-1");
        }
        return super.getIndexedValues(ResolutionIndexInfoResolver.cleanOperand(singleValueOperand));
    }

    private static boolean isUnresolvedOperand(String operand) {
        return UNRESOLVED_OPERAND.equalsIgnoreCase(operand);
    }

    static String cleanOperand(String operand) {
        Pattern p = Pattern.compile("['\"]+unresolved['\"]+", 2);
        Matcher m = p.matcher(operand);
        if (m.find() && (operand.startsWith("'") && operand.endsWith("'") || operand.startsWith("\"") && operand.endsWith("\""))) {
            return operand.substring(1, operand.length() - 1);
        }
        return operand;
    }
}

