/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

@InjectableComponent
public class JqlSelectOptionsUtil {
    private final OptionsManager optionsManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;

    public JqlSelectOptionsUtil(OptionsManager optionsManager, FieldConfigSchemeManager fieldConfigSchemeManager, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil) {
        this.optionsManager = optionsManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.fieldConfigSchemeClauseContextUtil = fieldConfigSchemeClauseContextUtil;
    }

    public List<Option> getOptions(CustomField customField, QueryContext queryContext, QueryLiteral literal, boolean checkOptionIds) {
        if (literal.isEmpty()) {
            return Collections.emptyList();
        }
        FieldConfigScheme scheme = this.fieldConfigSchemeClauseContextUtil.getFieldConfigSchemeFromContext(queryContext, customField);
        if (scheme == null) {
            return Collections.emptyList();
        }
        List<Option> customFieldOptions = this.getOptions(customField, literal, checkOptionIds);
        return new ArrayList<Option>(CollectionUtils.intersection(customFieldOptions, this.getOptionsForScheme(scheme)));
    }

    public List<Option> getOptions(CustomField customField, ApplicationUser user, QueryLiteral literal, boolean checkOptionIds) {
        List<Option> options = this.getOptions(customField, literal, checkOptionIds);
        ArrayList<Option> visibleOptions = new ArrayList<Option>();
        for (Option option : options) {
            if (option == null || !this.optionIsVisible(option, user)) continue;
            visibleOptions.add(option);
        }
        return visibleOptions;
    }

    public Option getOptionById(Long optionId) {
        return this.optionsManager.findByOptionId(optionId);
    }

    public List<Option> getOptions(CustomField customField, QueryLiteral literal, boolean checkOptionIds) {
        if (literal.getLongValue() != null) {
            List<Option> options;
            Long value = literal.getLongValue();
            if (checkOptionIds && !(options = this.getOptionFromLong(customField, value)).isEmpty()) {
                return options;
            }
            return this.getOptionFromString(customField, value.toString());
        }
        if (literal.getStringValue() != null) {
            Long lValue;
            String value = literal.getStringValue();
            List<Option> options = this.getOptionFromString(customField, value);
            if (options.isEmpty() && checkOptionIds && (lValue = this.getLong(value)) != null) {
                return this.getOptionFromLong(customField, lValue);
            }
            return options;
        }
        return Collections.singletonList(null);
    }

    public List<Option> getOptionsForScheme(FieldConfigScheme fieldConfigScheme) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        Set configSet = fieldConfigScheme.getConfigsByConfig().keySet();
        for (FieldConfig fieldConfig : configSet) {
            Options options = this.optionsManager.getOptions(fieldConfig);
            if (options == null) continue;
            for (Object o : options) {
                Option option = (Option)o;
                optionList.add(option);
                optionList.addAll(option.getChildOptions());
            }
        }
        return optionList;
    }

    boolean optionIsVisible(Option option, ApplicationUser user) {
        FieldConfig fieldConfig = option.getRelatedCustomField();
        FieldConfigScheme scheme = this.fieldConfigSchemeManager.getConfigSchemeForFieldConfig(fieldConfig);
        if (scheme != null) {
            ClauseContext context = this.fieldConfigSchemeClauseContextUtil.getContextForConfigScheme(user, scheme);
            return !context.getContexts().isEmpty();
        }
        return false;
    }

    private Long getLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private List<Option> getOptionFromString(CustomField customField, String value) {
        List options = this.optionsManager.findByOptionValue(value);
        ArrayList customFieldOptions = Lists.newArrayListWithCapacity((int)options.size());
        for (Option option : options) {
            CustomField field = this.getFieldFromOption(option);
            if (field == null || !field.equals(customField)) continue;
            customFieldOptions.add(option);
        }
        return customFieldOptions;
    }

    private List<Option> getOptionFromLong(CustomField customField, Long value) {
        CustomField field;
        Option option = this.optionsManager.findByOptionId(value);
        if (option != null && (field = this.getFieldFromOption(option)) != null && field.equals(customField)) {
            return Collections.singletonList(option);
        }
        return Collections.emptyList();
    }

    private CustomField getFieldFromOption(Option option) {
        try {
            FieldConfig relatedCustomField = option.getRelatedCustomField();
            if (relatedCustomField == null) {
                return null;
            }
            return relatedCustomField.getCustomField();
        }
        catch (DataAccessException e) {
            return null;
        }
        catch (LazyReference.InitializationException ie) {
            return null;
        }
    }
}

