/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.LicenseDetails;
import com.google.common.collect.ImmutableList;
import java.util.List;

public interface LicenseCheck {
    public static final Result PASS = new Result((Iterable<? extends LicenseDetails>)ImmutableList.of(), "");
    public static final Result FAIL = new Failure((List<? extends LicenseDetails>)ImmutableList.of(), "");
    public static final Result FAIL_NO_LICENSES = new Failure((List<? extends LicenseDetails>)ImmutableList.of(), "No licenses present");

    public Result evaluate();

    default public boolean isPass() {
        return this.evaluate().isPass();
    }

    public static class Failure
    extends Result {
        public Failure(List<? extends LicenseDetails> failedLicenses, String failureMessage) {
            super(failedLicenses, failureMessage);
        }

        @Override
        public boolean isPass() {
            return false;
        }
    }

    public static class Result {
        private final List<LicenseDetails> failedLicenses;
        private final String failureMessage;

        public Result(Iterable<? extends LicenseDetails> failedLicenses, String failureMessage) {
            this.failedLicenses = ImmutableList.copyOf(failedLicenses);
            this.failureMessage = failureMessage;
        }

        public List<LicenseDetails> getFailedLicenses() {
            return this.failedLicenses;
        }

        public String getFailureMessage() {
            return this.failureMessage;
        }

        public boolean isPass() {
            return this.failedLicenses.isEmpty();
        }
    }
}

