/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarManagerImpl;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.MailImageInliner;
import com.atlassian.jira.mail.util.MailAttachment;
import com.atlassian.jira.mail.util.MailAttachments;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.mail.util.MailAttachmentsManagerFactory;
import com.atlassian.jira.util.Longs;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MailImageInlinerImpl
implements MailImageInliner {
    private static final Logger log = LoggerFactory.getLogger(MailImageInlinerImpl.class);
    private static final String HTML_LINK = "a";
    private static final String HTML_IMG = "img";
    private static final String HTML_SRC = "src";
    private static final String HTML_ID = "id";
    private static final String CONTENT_ID_PREFIX = "cid:";
    private static final String THUMBNAIL_PATH = "/secure/thumbnail";
    private static final String THUMBNAIL_ID = "_thumb";
    private static final String ATTACHMENT_PATH = "/secure/attachment";
    private static final BiFunction<String, String, Option<String>> substringAfterToOptionFunction = (imageSource, find) -> {
        String s = StringUtils.substringAfterLast((String)imageSource, (String)find);
        if (StringUtils.isNotBlank((CharSequence)s)) {
            return Option.some((Object)s);
        }
        return Option.none();
    };
    private final AvatarManager avatarManager;
    private final AttachmentManager attachmentManager;
    private final ThumbnailManager thumbnailManager;
    private final MailAttachmentsManagerFactory mailAttachmentsManagerFactory;

    public MailImageInlinerImpl(AvatarManager avatarManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager, MailAttachmentsManagerFactory mailAttachmentsManagerFactory) {
        this.avatarManager = avatarManager;
        this.attachmentManager = attachmentManager;
        this.thumbnailManager = thumbnailManager;
        this.mailAttachmentsManagerFactory = mailAttachmentsManagerFactory;
    }

    @Nonnull
    public MailImageInliner.InlinedEmailBody inlineImages(String html) {
        return this.doInlineImages(html, Collections.emptyList());
    }

    @Nonnull
    public MailImageInliner.InlinedEmailBody inlineImages(String html, Issue issue) {
        List<Attachment> attachments = issue.getAttachments() != null ? issue.getAttachments() : Collections.emptyList();
        return this.doInlineImages(html, attachments);
    }

    private MailImageInliner.InlinedEmailBody doInlineImages(String html, Collection<Attachment> issueAttachments) {
        MailAttachmentsManager mailAttachmentsManager = this.mailAttachmentsManagerFactory.createAttachmentsManager();
        String updatedHtml = mailAttachmentsManager.inlineImages(html);
        Document document = Jsoup.parse((String)updatedHtml);
        Elements images = document.body().getElementsByTag(HTML_IMG);
        HashMap mailAttachmentCache = Maps.newHashMap();
        for (Element imageElement : images) {
            String imgSrc = imageElement.attr(HTML_SRC);
            if (this.isLinkOnInstance(imgSrc, mailAttachmentsManager)) {
                this.constructMailAttachment(imageElement, issueAttachments, mailAttachmentCache).forEach(mailAttachment -> this.addToAttachmentListAndUpdateHTML(imageElement, mailAttachmentsManager, (MailAttachment)mailAttachment));
                continue;
            }
            log.debug("skipping image not served by JIRA: {}", (Object)imgSrc);
        }
        return new MailImageInliner.InlinedEmailBody(document.outerHtml(), mailAttachmentsManager.buildAttachmentsBodyParts());
    }

    private boolean isLinkOnInstance(String link, MailAttachmentsManager mailAttachmentsManager) {
        return !link.equals(mailAttachmentsManager.removeBaseUrl(link));
    }

    @VisibleForTesting
    void addToAttachmentListAndUpdateHTML(Element imageElement, MailAttachmentsManager mailAttachmentsManager, MailAttachment mailAttachment) {
        String cid = mailAttachmentsManager.addAttachmentAndReturnCid(mailAttachment);
        imageElement.attr(HTML_SRC, cid);
    }

    private Option<MailAttachment> getMailAttachmentForAvatarIcon(String imageSrc) {
        try {
            URI uri = new URI(imageSrc);
            if (JiraMailUtils.isAvatarUrl(uri)) {
                HashMap queries = Maps.newHashMap();
                URLEncodedUtils.parse((URI)uri, (Charset)StandardCharsets.UTF_8).forEach(nameValuePair -> queries.put(nameValuePair.getName(), nameValuePair.getValue()));
                Option avatarIdMaybe = Option.fromOptional((Optional)Longs.toLongMaybe((String)((String)queries.get("avatarId"))));
                IconType iconType = IconType.of((String)((String)queries.get("avatarType")));
                Avatar.Size size = this.getValidOrDefaultSize((String)queries.get("size"));
                return (Option)avatarIdMaybe.flatMap(avatarId -> this.getValidAvatarFromParams((Long)avatarId, iconType)).fold(Option::none, avatar -> this.avatarToMailAttachment(this.avatarManager, (Avatar)avatar, size));
            }
        }
        catch (Exception e) {
            log.warn("Error getting MailAttachment for avatar icon: " + imageSrc, (Throwable)e);
        }
        return Option.none();
    }

    private Avatar.Size getValidOrDefaultSize(String sizeFromQuery) {
        return (Avatar.Size)Option.option((Object)sizeFromQuery).map(Avatar.Size::getSizeFromParam).getOr(Avatar.Size::defaultSize);
    }

    private Option<MailAttachment> avatarToMailAttachment(AvatarManager avatarManager, Avatar avatar, Avatar.Size size) {
        if (AvatarManagerImpl.isAvatarTranscodeable(avatar)) {
            return Option.some((Object)MailAttachments.newTranscodedAvatarAttachment(avatar, "", avatarManager, size));
        }
        return Option.some((Object)MailAttachments.newAvatarAttachment(avatar, "", avatarManager, size));
    }

    private Option<Avatar> getValidAvatarFromParams(Long id, IconType iconType) {
        Avatar avatar = this.avatarManager.getByIdTagged(id);
        if (null == avatar) {
            log.debug(" avatarManager.getByIdTagged {} could not be resolved.", (Object)id);
            return Option.none();
        }
        IconType actualAvatarType = avatar.getIconType();
        if (!actualAvatarType.equals((Object)iconType)) {
            log.debug(" requested type {} doesn't match avatar.iconType: {}", (Object)iconType, (Object)actualAvatarType);
            return Option.none();
        }
        return Option.some((Object)avatar);
    }

    private Option<MailAttachment> constructMailAttachment(Element imageElement, Collection<Attachment> issueAttachments, Map<String, MailAttachment> mailAttachmentCache) {
        return this.mailAttachmentForJIRAIssueAttachment(imageElement, issueAttachments, mailAttachmentCache).orElse(() -> this.mailAttachmentForAvatarIcon(imageElement.attr(HTML_SRC), mailAttachmentCache));
    }

    private Option<MailAttachment> mailAttachmentForJIRAIssueAttachment(Element imageElement, Collection<Attachment> issueAttachments, Map<String, MailAttachment> mailAttachmentCache) {
        MailAttachment cachedMailAttachment;
        if (issueAttachments.isEmpty()) {
            return Option.none();
        }
        String imageSource = imageElement.attr(HTML_SRC);
        if (StringUtils.isBlank((CharSequence)imageSource) || StringUtils.startsWithIgnoreCase((CharSequence)imageSource, (CharSequence)CONTENT_ID_PREFIX)) {
            return Option.none();
        }
        if (mailAttachmentCache.containsKey(imageSource) && (cachedMailAttachment = mailAttachmentCache.get(imageSource)) != null) {
            return Option.some((Object)cachedMailAttachment);
        }
        Long id = (Long)substringAfterToOptionFunction.apply(imageSource, ATTACHMENT_PATH).orElse(() -> substringAfterToOptionFunction.apply(imageSource, THUMBNAIL_PATH)).flatMap(p -> Option.option((Object)StringUtils.substringBetween((String)p, (String)"/"))).flatMap(imId -> {
            try {
                return Option.option((Object)Long.parseLong(imId));
            }
            catch (NumberFormatException nfe) {
                log.warn("{} can not be converted to a Long - the image id appears invalid", imId);
                return Option.none();
            }
        }).getOrNull();
        if (id == null) {
            log.debug("No id was able to be extracted from the HTML image source of {}", (Object)imageSource);
            return Option.none();
        }
        Option attachment = Iterables.findFirst(issueAttachments, att -> id.equals(att.getId()));
        if (attachment.isEmpty()) {
            log.debug("No attachment was found with id {} from HTML image source of {}", (Object)id, (Object)imageSource);
            return Option.none();
        }
        boolean thumbnail = imageSource.contains(THUMBNAIL_PATH) || Option.option((Object)imageElement.parent()).filter(el -> HTML_LINK.equals(el.tagName())).flatMap(el -> Option.option((Object)el.attr(HTML_ID))).exists(thId -> thId.endsWith(THUMBNAIL_ID));
        MailAttachment mailAttachment = thumbnail ? MailAttachments.newMailAttachmentByStreamingFromThumbnailManager((Attachment)attachment.get(), this.thumbnailManager) : MailAttachments.newMailAttachmentByStreamingFromAttachmentManager((Attachment)attachment.get(), this.attachmentManager);
        mailAttachmentCache.put(imageSource, mailAttachment);
        return Option.option((Object)mailAttachment);
    }

    private Option<MailAttachment> mailAttachmentForAvatarIcon(String imgSrc, Map<String, MailAttachment> mailAttachmentCache) {
        if (!mailAttachmentCache.containsKey(imgSrc)) {
            this.getMailAttachmentForAvatarIcon(imgSrc).forEach(mailAttachment -> mailAttachmentCache.put(imgSrc, (MailAttachment)mailAttachment));
        }
        return Option.option((Object)mailAttachmentCache.get(imgSrc));
    }
}

