/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.MailThreadManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.fugue.Iterables;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailThreadManagerImpl
implements MailThreadManager {
    private static final Logger log = LoggerFactory.getLogger(MailThreadManagerImpl.class);
    private final OfBizDelegator ofBizDelegator;
    private final IssueManager issueManager;

    public MailThreadManagerImpl(OfBizDelegator ofBizDelegator, IssueManager issueManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueManager = issueManager;
    }

    public void storeIncomingMessageId(String messageId, String senderAddress, Issue issue, MailThreadManager.MailAction action) {
        Assertions.notNull((String)"messageId", (Object)messageId);
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"action", (Object)action);
        FieldMap fields = new FieldMap();
        fields.put((Object)"type", (Object)action.toString());
        fields.put((Object)"source", (Object)issue.getId());
        fields.put((Object)"email", (Object)senderAddress);
        fields.put((Object)"messageid", (Object)messageId);
        this.ofBizDelegator.createValue("NotificationInstance", (Map)fields);
    }

    public void threadNotificationEmail(Email email, Issue issue) {
        List<String> replyToIds = JiraMailUtils.getReplyToIds(issue);
        email.setInReplyTo(replyToIds.get(0));
        StringBuilder replyToIdsStringBuilder = new StringBuilder();
        for (int i = 0; i < replyToIds.size(); ++i) {
            if (i > 0) {
                replyToIdsStringBuilder.append(" ");
            }
            replyToIdsStringBuilder.append(replyToIds.get(i));
        }
        email.addHeader("References", replyToIdsStringBuilder.toString());
    }

    @Nonnull
    public List<Issue> getAssociatedIssueObjects(Message message) {
        try {
            String[] messageIds = message.getHeader("In-Reply-To");
            if (messageIds != null && messageIds.length > 0) {
                for (String messageId : messageIds) {
                    List<Issue> issues = this.getAssociatedIssuesFromMessageId(messageId);
                    if (issues.isEmpty()) continue;
                    return issues;
                }
            } else {
                log.debug("No In-Reply-To header found");
            }
            String[] values = message.getHeader("References");
            if (values != null && values.length > 0) {
                for (String value : values) {
                    for (String messageId : this.extractMessageIdsFromReferences(value)) {
                        List<Issue> issues = this.getAssociatedIssuesFromMessageId(messageId);
                        if (issues.isEmpty()) continue;
                        return issues;
                    }
                }
            } else {
                log.debug("No References header found for message '" + message.getSubject() + "'");
            }
        }
        catch (MessagingException e) {
            log.error("Error occurred while determining message id of an e-mail message.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Nullable
    public Issue getAssociatedIssueObject(Message message) {
        return (Issue)Iterables.first(this.getAssociatedIssueObjects(message)).getOrNull();
    }

    private List<String> extractMessageIdsFromReferences(String value) {
        ArrayList<String> messageIds = new ArrayList<String>();
        if (value == null) {
            return messageIds;
        }
        int nextMessageIdIndex = value.indexOf(60);
        while (nextMessageIdIndex > -1) {
            int endIndex = value.indexOf(62, nextMessageIdIndex);
            if (endIndex == -1) {
                nextMessageIdIndex = -1;
                continue;
            }
            messageIds.add(value.substring(nextMessageIdIndex, endIndex + 1));
            nextMessageIdIndex = value.indexOf(60, endIndex);
        }
        return messageIds;
    }

    private List<Issue> getAssociatedIssuesFromMessageId(String messageId) {
        int index = messageId.indexOf(";");
        if (index > 0) {
            messageId = messageId.substring(0, index);
        }
        if (messageId.startsWith("<JIRA.")) {
            Issue issue = this.parseIssueFromMessageId(messageId);
            if (issue == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(issue);
        }
        return this.findIssuesFromMessageId(messageId);
    }

    private Issue parseIssueFromMessageId(String messageId) {
        Long createdDate;
        Long issueId;
        String[] sections = messageId.split("\\.|@");
        try {
            issueId = new Long(sections[1]);
            createdDate = "null".equals(sections[2]) ? null : Long.valueOf(Long.parseLong(sections[2]));
        }
        catch (RuntimeException ex) {
            log.error("Unable to parse incoming In-Reply-To header " + messageId);
            return null;
        }
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            return null;
        }
        Timestamp created = issue.getCreated();
        if (createdDate == null || created == null) {
            return issue;
        }
        if (created.getTime() / 1000L == createdDate / 1000L) {
            return issue;
        }
        log.warn("Received In-Reply-To header " + messageId + " but issue " + issue.getKey() + " does not match incoming creation date - assuming this is from another server and ignoring.");
        return null;
    }

    public Issue findIssueFromMessageId(String messageId) {
        return (Issue)Iterables.first(this.findIssuesFromMessageId(messageId)).getOrNull();
    }

    @Nonnull
    public List<Issue> findIssuesFromMessageId(String messageId) {
        if (StringUtils.isBlank((CharSequence)messageId)) {
            return Collections.emptyList();
        }
        List notificationInstanceGVs = this.ofBizDelegator.findByAnd("NotificationInstance", (Map)FieldMap.build((String)"messageid", (Object)messageId));
        if (notificationInstanceGVs == null || notificationInstanceGVs.isEmpty()) {
            log.debug("Cannot find any associated issues with message id '" + messageId + "'.");
            return Collections.emptyList();
        }
        return (List)notificationInstanceGVs.stream().map(notificationInstanceGV -> notificationInstanceGV.getLong("source")).map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0)).filter(Objects::nonNull).collect(CollectorsUtil.toImmutableList());
    }

    public int removeAssociatedEntries(Long issueId) {
        return this.ofBizDelegator.removeByAnd("NotificationInstance", (Map)FieldMap.build((String)"source", (Object)issueId));
    }
}

