/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.util;

import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.mail.attachment.ImageAttachmentAltAttributeService;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.security.jwt.ImageAttachmentJwtTokenService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.InjectableComponent;
import com.google.common.base.Preconditions;

@InjectableComponent
public class MailAttachmentsManagerFactory {
    private final AvatarManager avatarManager;
    private final AvatarService avatarService;
    private final AvatarTranscoder avatarTranscoder;
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final ImageAttachmentJwtTokenService imageAttachmentJwtTokenService;
    private final ImageAttachmentAltAttributeService imageAttachmentAltAttributeService;

    public MailAttachmentsManagerFactory(AvatarManager avatarManager, AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, ApplicationProperties applicationProperties, ImageAttachmentJwtTokenService imageAttachmentJwtTokenService, ImageAttachmentAltAttributeService imageAttachmentAltAttributeService) {
        this.avatarManager = avatarManager;
        this.avatarService = avatarService;
        this.avatarTranscoder = avatarTranscoder;
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.imageAttachmentJwtTokenService = imageAttachmentJwtTokenService;
        this.imageAttachmentAltAttributeService = imageAttachmentAltAttributeService;
    }

    public MailAttachmentsManager createAttachmentsManager() {
        return MailAttachmentsManagerImpl.withoutJwtTokens(this.avatarService, this.avatarTranscoder, this.userManager, this.avatarManager, this.applicationProperties, this.imageAttachmentJwtTokenService, this.imageAttachmentAltAttributeService);
    }

    public MailAttachmentsManager createAttachmentsManagerWithJwtTokens(String recipientUserName) {
        Preconditions.checkNotNull((Object)recipientUserName);
        Preconditions.checkArgument((!recipientUserName.isEmpty() ? 1 : 0) != 0);
        return MailAttachmentsManagerImpl.withJwtTokens(this.avatarService, this.avatarTranscoder, this.userManager, this.avatarManager, this.applicationProperties, this.imageAttachmentJwtTokenService, this.imageAttachmentAltAttributeService, recipientUserName);
    }
}

