/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.memoryinspector;

import com.atlassian.jira.memoryinspector.InspectionReport;
import com.atlassian.jira.memoryinspector.ThreadsInspector;
import com.atlassian.jira.memoryinspector.ThreadsInspectorImpl;
import com.atlassian.jira.memoryinspector.ThreadsProvider;
import com.atlassian.jira.memoryinspector.ThreadsProviderImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Period;

public class MemoryInspector {
    @VisibleForTesting
    static final String MEMORY_INSPECTION_FAILED_HEADER = "----------------------- MEMORY INSPECTION FAILED -------------------------------------";
    @VisibleForTesting
    static final String MEMORY_INSPECTION_FAILED_FOOTER = "______________________________________________________________________________________";
    private static final Logger log = Logger.getLogger(MemoryInspector.class);
    private final ThreadsProvider threadsProvider;
    private final ThreadsInspector threadsInspector;

    public MemoryInspector() {
        this(new ThreadsProviderImpl(), new ThreadsInspectorImpl());
    }

    public MemoryInspector(ThreadsProvider threadsProvider, ThreadsInspector threadsInspector) {
        this.threadsProvider = threadsProvider;
        this.threadsInspector = threadsInspector;
    }

    public void inspectMemoryAfterJiraShutdown() {
        this.inspectMemoryAfterJiraShutdownWithRetries(log, 100, Period.millis((int)100));
    }

    @VisibleForTesting
    void inspectMemoryAfterJiraShutdownWithRetries(Logger log, int retries, Period waitTime) {
        List<InspectionReport> inspectionReports = this.executeAllInspectionsWithTimeout(retries, waitTime);
        if (!this.allInspectionsPassed(inspectionReports)) {
            log.warn((Object)MEMORY_INSPECTION_FAILED_HEADER);
            for (InspectionReport inspectionReport : inspectionReports) {
                if (inspectionReport.inspectionPassed()) continue;
                inspectionReport.printReport(log);
            }
            log.warn((Object)MEMORY_INSPECTION_FAILED_FOOTER);
        }
    }

    private List<InspectionReport> executeAllInspectionsWithTimeout(int retries, Period waitTime) {
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (String)"Retries cannot be negative! Given value: %s", (int)retries);
        int remainingRetires = retries;
        while (remainingRetires-- >= 0) {
            ImmutableList inspectionReports = ImmutableList.of((Object)this.threadsInspector.inspectThreads(this.threadsProvider.getAllThreads()));
            if (this.allInspectionsPassed((List<InspectionReport>)inspectionReports) || remainingRetires <= 0) {
                return inspectionReports;
            }
            this.sleep(waitTime);
        }
        throw new RuntimeException("I did not expect to end here.");
    }

    private void sleep(Period sleepTime) {
        try {
            Thread.sleep(sleepTime.getMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean allInspectionsPassed(List<InspectionReport> inspectionReports) {
        return Iterables.all(inspectionReports, InspectionReport::inspectionPassed);
    }
}

