/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.model.querydsl;

import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.sql.Timestamp;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class ClusterMessageDTO
implements DTO {
    private final Long id;
    private final String sourceNode;
    private final String destinationNode;
    private final String claimedByNode;
    private final String message;
    private final Timestamp messageTime;

    public Long getId() {
        return this.id;
    }

    public String getSourceNode() {
        return this.sourceNode;
    }

    public String getDestinationNode() {
        return this.destinationNode;
    }

    public String getClaimedByNode() {
        return this.claimedByNode;
    }

    public String getMessage() {
        return this.message;
    }

    public Timestamp getMessageTime() {
        return this.messageTime;
    }

    public ClusterMessageDTO(Long id, String sourceNode, String destinationNode, String claimedByNode, String message, Timestamp messageTime) {
        this.id = id;
        this.sourceNode = sourceNode;
        this.destinationNode = destinationNode;
        this.claimedByNode = claimedByNode;
        this.message = message;
        this.messageTime = messageTime;
    }

    @Override
    public GenericValue toGenericValue(OfBizDelegator ofBizDelegator) {
        return ofBizDelegator.makeValue("ClusterMessage", (Map)new FieldMap().add("id", (Object)this.id).add("sourceNode", (Object)this.sourceNode).add("destinationNode", (Object)this.destinationNode).add("claimedByNode", (Object)this.claimedByNode).add("message", (Object)this.message).add("messageTime", (Object)this.messageTime));
    }

    public static ClusterMessageDTO fromGenericValue(GenericValue gv) {
        return new ClusterMessageDTO(gv.getLong("id"), gv.getString("sourceNode"), gv.getString("destinationNode"), gv.getString("claimedByNode"), gv.getString("message"), gv.getTimestamp("messageTime"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterMessageDTO clusterMessageDTO) {
        return new Builder(clusterMessageDTO);
    }

    public static class Builder {
        private Long id;
        private String sourceNode;
        private String destinationNode;
        private String claimedByNode;
        private String message;
        private Timestamp messageTime;

        public Builder() {
        }

        public Builder(ClusterMessageDTO clusterMessageDTO) {
            this.id = clusterMessageDTO.id;
            this.sourceNode = clusterMessageDTO.sourceNode;
            this.destinationNode = clusterMessageDTO.destinationNode;
            this.claimedByNode = clusterMessageDTO.claimedByNode;
            this.message = clusterMessageDTO.message;
            this.messageTime = clusterMessageDTO.messageTime;
        }

        public ClusterMessageDTO build() {
            return new ClusterMessageDTO(this.id, this.sourceNode, this.destinationNode, this.claimedByNode, this.message, this.messageTime);
        }

        public Builder id(Long id) {
            this.id = id;
            return this;
        }

        public Builder sourceNode(String sourceNode) {
            this.sourceNode = sourceNode;
            return this;
        }

        public Builder destinationNode(String destinationNode) {
            this.destinationNode = destinationNode;
            return this;
        }

        public Builder claimedByNode(String claimedByNode) {
            this.claimedByNode = claimedByNode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder messageTime(Timestamp messageTime) {
            this.messageTime = messageTime;
            return this;
        }
    }
}

