/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.model.querydsl;

import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.MoreObjects;
import java.sql.Timestamp;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class IssueVersionDTO
implements DTO {
    private final Long issueId;
    private final Long parentIssueId;
    private final Timestamp updateTime;
    private final Long indexVersion;
    private final String deleted;

    public Long getIssueId() {
        return this.issueId;
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public Long getIndexVersion() {
        return this.indexVersion;
    }

    public String getDeleted() {
        return this.deleted;
    }

    public IssueVersionDTO(Long issueId, Long parentIssueId, Timestamp updateTime, Long indexVersion, String deleted) {
        this.issueId = issueId;
        this.parentIssueId = parentIssueId;
        this.updateTime = updateTime;
        this.indexVersion = indexVersion;
        this.deleted = deleted;
    }

    @Override
    public GenericValue toGenericValue(OfBizDelegator ofBizDelegator) {
        return ofBizDelegator.makeValue("IssueVersion", (Map)new FieldMap().add("issueId", (Object)this.issueId).add("parentIssueId", (Object)this.parentIssueId).add("updateTime", (Object)this.updateTime).add("indexVersion", (Object)this.indexVersion).add("deleted", (Object)this.deleted));
    }

    public static IssueVersionDTO fromGenericValue(GenericValue gv) {
        return new IssueVersionDTO(gv.getLong("issueId"), gv.getLong("parentIssueId"), gv.getTimestamp("updateTime"), gv.getLong("indexVersion"), gv.getString("deleted"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issueId", (Object)this.issueId).add("parentIssueId", (Object)this.parentIssueId).add("updateTime", (Object)this.updateTime).add("indexVersion", (Object)this.indexVersion).add("deleted", (Object)this.deleted).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IssueVersionDTO issueVersionDTO) {
        return new Builder(issueVersionDTO);
    }

    public static class Builder {
        private Long issueId;
        private Long parentIssueId;
        private Timestamp updateTime;
        private Long indexVersion;
        private String deleted;

        public Builder() {
        }

        public Builder(IssueVersionDTO issueVersionDTO) {
            this.issueId = issueVersionDTO.issueId;
            this.parentIssueId = issueVersionDTO.parentIssueId;
            this.updateTime = issueVersionDTO.updateTime;
            this.indexVersion = issueVersionDTO.indexVersion;
            this.deleted = issueVersionDTO.deleted;
        }

        public IssueVersionDTO build() {
            return new IssueVersionDTO(this.issueId, this.parentIssueId, this.updateTime, this.indexVersion, this.deleted);
        }

        public Builder issueId(Long issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder parentIssueId(Long parentIssueId) {
            this.parentIssueId = parentIssueId;
            return this;
        }

        public Builder updateTime(Timestamp updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder indexVersion(Long indexVersion) {
            this.indexVersion = indexVersion;
            return this;
        }

        public Builder deleted(String deleted) {
            this.deleted = deleted;
            return this;
        }
    }
}

