/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentReporter
extends AbstractNotificationType {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentReporter.class);
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CurrentReporter(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        Issue issue = event.getIssue();
        if (issue != null) {
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(issue.getReporterId());
            String level = (String)event.getParams().get("level");
            if (user != null && (level == null || CurrentReporter.userInGroup(user, level))) {
                return Lists.newArrayList((Object[])new NotificationRecipient[]{new NotificationRecipient(user)});
            }
            return Collections.emptyList();
        }
        LOG.error("Error getting reporter notification recipients - no issue associated with event: " + event.getEventTypeId());
        return Collections.emptyList();
    }

    private static boolean userInGroup(ApplicationUser user, String groupName) {
        return ComponentAccessor.getGroupManager().isUserInGroup(user, groupName);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.reporter");
    }
}

