/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.group.search.GroupPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class GroupDropdown
extends AbstractNotificationType {
    private static final String EMPTY_QUERY = "";
    private final GroupPickerSearchService groupPickerSearchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public GroupDropdown(GroupPickerSearchService groupPickerSearchService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.groupPickerSearchService = groupPickerSearchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String groupName) {
        SortedSet users = this.getUserUtil().getAllUsersInGroupNames(Arrays.asList(groupName));
        ArrayList recipients = Lists.newArrayListWithCapacity((int)users.size());
        for (ApplicationUser user : users) {
            recipients.add(new NotificationRecipient(user));
        }
        return recipients;
    }

    private UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.group");
    }

    @Override
    public String getType() {
        return "group";
    }

    public Collection getGroups() {
        return this.findAllGroups();
    }

    @Override
    public boolean doValidation(String key, Map parameters) {
        Object value = parameters.get(key);
        return value != null && TextUtils.stringSet((String)((String)value));
    }

    private Collection<Group> findAllGroups() {
        return this.groupPickerSearchService.findGroups(EMPTY_QUERY);
    }
}

