/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;

public class DefaultOfBizConnectionFactory
implements OfBizConnectionFactory {
    private final EntityConfigUtil entityConfigUtil = EntityConfigUtil.getInstance();
    @ClusterSafe
    private final ResettableLazyReference<DatabaseConfig> databaseConfigurationRef = new ResettableLazyReference<DatabaseConfig>(){

        protected DatabaseConfig create() throws Exception {
            return ((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class)).getDatabaseConfiguration();
        }
    };

    public static DefaultOfBizConnectionFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public Connection getConnection() throws SQLException, DataAccessException {
        try {
            return ConnectionFactory.getConnection((String)this.getDatabaseConfig().getDatasourceName());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public DatasourceInfo getDatasourceInfo() {
        return this.entityConfigUtil.getDatasourceInfo(this.getDatabaseConfig().getDatasourceName());
    }

    @Override
    public String getDelegatorName() {
        return this.getDatabaseConfig().getDelegatorName();
    }

    public void resetInstance() {
        this.databaseConfigurationRef.reset();
    }

    private DatabaseConfig getDatabaseConfig() {
        return (DatabaseConfig)this.databaseConfigurationRef.get();
    }

    private static final class InstanceHolder {
        private static final DefaultOfBizConnectionFactory INSTANCE = new DefaultOfBizConnectionFactory();

        private InstanceHolder() {
        }
    }
}

