/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeUtil;
import com.atlassian.jira.permission.data.CustomPermissionHolderType;
import com.atlassian.jira.permission.data.PermissionGrantImpl;
import com.atlassian.jira.permission.data.PermissionSchemeImpl;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Options;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class PermissionSchemeRepresentationConverter {
    private static final String SCHEME_TYPE = "permission";

    public PermissionScheme permissionScheme(Scheme scheme) {
        return new PermissionSchemeImpl(scheme.getId(), scheme.getName(), scheme.getDescription(), Options.flatten((Iterable)Iterables.transform((Iterable)scheme.getEntities(), this::permissionGrant)));
    }

    public Scheme scheme(PermissionScheme permissionScheme) {
        return new Scheme(permissionScheme.getId(), SCHEME_TYPE, permissionScheme.getName(), permissionScheme.getDescription(), (Collection)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)permissionScheme.getPermissions(), input -> this.schemeEntity((PermissionGrant)input, permissionScheme.getId()))));
    }

    public Scheme scheme(PermissionSchemeInput permissionScheme) {
        return new Scheme(null, SCHEME_TYPE, permissionScheme.getName(), (String)permissionScheme.getDescription().getOrNull(), (Collection)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)permissionScheme.getPermissions(), input -> this.schemeEntity((PermissionGrantInput)input, null))));
    }

    public Option<PermissionGrant> permissionGrant(SchemeEntity schemeEntity) {
        return PermissionSchemeUtil.getPermissionKey(schemeEntity).map(permissionKey -> new PermissionGrantImpl(schemeEntity.getId(), PermissionSchemeRepresentationConverter.holder(schemeEntity.getType(), schemeEntity.getParameter()), (ProjectPermissionKey)permissionKey));
    }

    public SchemeEntity schemeEntity(PermissionGrant permissionGrant, Long schemeId) {
        Preconditions.checkNotNull((Object)schemeId);
        return new SchemeEntity(permissionGrant.getId(), permissionGrant.getHolder().getType().getKey(), (String)permissionGrant.getHolder().getParameter().getOrNull(), (Object)permissionGrant.getPermission(), null, schemeId);
    }

    public SchemeEntity schemeEntity(PermissionGrantInput permissionGrant, @Nullable Long schemeId) {
        return new SchemeEntity(null, permissionGrant.getHolder().getType().getKey(), (String)permissionGrant.getHolder().getParameter().getOrNull(), (Object)permissionGrant.getPermission(), null, schemeId);
    }

    private static PermissionHolder holder(String key, @Nullable String parameter) {
        Option jiraPermissionHolderType = JiraPermissionHolderType.fromKey((String)key, (String)parameter);
        if (jiraPermissionHolderType.isDefined()) {
            return PermissionHolder.holder((PermissionHolderType)((PermissionHolderType)jiraPermissionHolderType.get()), (String)parameter);
        }
        return PermissionHolder.holder((PermissionHolderType)CustomPermissionHolderType.permissionHolderType(key, parameter), (String)parameter);
    }
}

