/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission;

import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.QueryDslAccessorHandlingCollationProblems;
import com.atlassian.jira.issue.customfields.CustomFieldTypes;
import com.atlassian.jira.model.querydsl.QApplicationUser;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldOption;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.model.querydsl.QDirectory;
import com.atlassian.jira.model.querydsl.QGroup;
import com.atlassian.jira.model.querydsl.QLicenseRoleGroup;
import com.atlassian.jira.model.querydsl.QNodeAssociation;
import com.atlassian.jira.model.querydsl.QProjectRoleActor;
import com.atlassian.jira.model.querydsl.QSchemePermissions;
import com.atlassian.jira.model.querydsl.QUser;
import com.atlassian.jira.model.querydsl.SchemePermissionsDTO;
import com.atlassian.jira.model.querydsl.UserDTO;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.SchemePermissionsDAO;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.annotation.Nullable;

public class QueryDSLSchemePermissionsDAO
implements SchemePermissionsDAO {
    private final QueryDslAccessor queryDslAccessor;

    public QueryDSLSchemePermissionsDAO(QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor) {
        this.queryDslAccessor = new QueryDslAccessorHandlingCollationProblems(queryDslAccessor, databaseAccessor.getDatabaseVendor(), "https://confluence.atlassian.com/jirakb/mentionable-assignable-users-database-collation-issues-1085194493.html");
    }

    @Override
    @Nullable
    public Long getPermissionSchemeIdFor(long projectId) {
        return this.queryDslAccessor.executeQuery(dbConnection -> (Long)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select(QNodeAssociation.NODE_ASSOCIATION.sinkNodeId).from((Expression)QNodeAssociation.NODE_ASSOCIATION)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QNodeAssociation.NODE_ASSOCIATION.sourceNodeEntity.eq((Object)"Project"), QNodeAssociation.NODE_ASSOCIATION.sourceNodeId.eq((Object)projectId), QNodeAssociation.NODE_ASSOCIATION.associationType.eq((Object)"ProjectScheme"), QNodeAssociation.NODE_ASSOCIATION.sinkNodeEntity.eq((Object)"PermissionScheme")}))).fetchOne());
    }

    @Override
    public List<SchemePermissionsDTO> getSchemePermissions(long schemeId, ProjectPermissionKey projectPermissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QSchemePermissions.SCHEME_PERMISSIONS).from((Expression)QSchemePermissions.SCHEME_PERMISSIONS)).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey())}))).fetch());
    }

    @Override
    public List<String> findGroupsFromTypeGroup(long schemeId, ProjectPermissionKey projectPermissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QGroup.GROUP.groupName).from((Expression)QGroup.GROUP)).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QGroup.GROUP.lowerGroupName.eq((Expression)QSchemePermissions.SCHEME_PERMISSIONS.parameter.lower()), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.GROUP.getKey())})).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QGroup.GROUP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).where((Predicate)QGroup.GROUP.active.eq((Object)1))).fetch());
    }

    @Override
    public List<String> findGroupsFromTypeProjectRoleGroup(long schemeId, long projectId, ProjectPermissionKey projectPermissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QGroup.GROUP.groupName).from((Expression)QGroup.GROUP)).innerJoin((EntityPath)QProjectRoleActor.PROJECT_ROLE_ACTOR)).on(new Predicate[]{QGroup.GROUP.lowerGroupName.eq((Expression)QProjectRoleActor.PROJECT_ROLE_ACTOR.roletypeparameter.lower()), QProjectRoleActor.PROJECT_ROLE_ACTOR.pid.eq((Object)projectId), QProjectRoleActor.PROJECT_ROLE_ACTOR.roletype.eq((Object)"atlassian-group-role-actor")})).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QProjectRoleActor.PROJECT_ROLE_ACTOR.projectroleid.stringValue().eq((Expression)QSchemePermissions.SCHEME_PERMISSIONS.parameter), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.PROJECT_ROLE.getKey())})).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QGroup.GROUP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).where((Predicate)QGroup.GROUP.active.eq((Object)1))).fetch());
    }

    @Override
    public List<String> findGroupsFromGroupCF(long schemeId, long issueId, ProjectPermissionKey projectPermissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QGroup.GROUP.groupName).from((Expression)QGroup.GROUP)).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QGroup.GROUP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).innerJoin((EntityPath)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on(new Predicate[]{QGroup.GROUP.lowerGroupName.eq((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.stringvalue.lower()), QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.eq((Object)issueId)})).innerJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on(new Predicate[]{QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield), QCustomField.CUSTOM_FIELD.customfieldtypekey.notIn((Object[])new String[]{CustomFieldTypes.SELECT.getKey(), CustomFieldTypes.MULTISELECT.getKey()})})).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QSchemePermissions.SCHEME_PERMISSIONS.parameter.eq((Expression)Expressions.asString((String)"customfield_").concat((Expression)QCustomField.CUSTOM_FIELD.id.stringValue())), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.GROUP_CUSTOM_FIELD.getKey())})).where((Predicate)QGroup.GROUP.active.eq((Object)1))).fetch());
    }

    @Override
    public List<String> findGroupsFromSelectCF(long schemeId, long issueId, ProjectPermissionKey projectPermissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QGroup.GROUP.groupName).from(new Expression[]{QSchemePermissions.SCHEME_PERMISSIONS, QCustomField.CUSTOM_FIELD, QCustomFieldValue.CUSTOM_FIELD_VALUE, QCustomFieldOption.CUSTOM_FIELD_OPTION, QGroup.GROUP, QDirectory.DIRECTORY})).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.GROUP_CUSTOM_FIELD.getKey()), QSchemePermissions.SCHEME_PERMISSIONS.parameter.eq((Expression)Expressions.asString((String)"customfield_").concat((Expression)QCustomField.CUSTOM_FIELD.id.stringValue())), QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield), QCustomFieldOption.CUSTOM_FIELD_OPTION.customfield.eq(QCustomField.CUSTOM_FIELD.id), QCustomFieldOption.CUSTOM_FIELD_OPTION.id.stringValue().eq((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.stringvalue), QCustomField.CUSTOM_FIELD.customfieldtypekey.in((Object[])new String[]{CustomFieldTypes.SELECT.getKey(), CustomFieldTypes.MULTISELECT.getKey()}), QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.eq((Object)issueId), QGroup.GROUP.lowerGroupName.eq((Expression)QCustomFieldOption.CUSTOM_FIELD_OPTION.value.lower()), QGroup.GROUP.active.eq((Object)1), QGroup.GROUP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)}))).fetch());
    }

    @Override
    public List<String> findGroupsFromApplicationRole(long schemeId, ProjectPermissionKey permissionKey) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QGroup.GROUP.groupName).from((Expression)QGroup.GROUP)).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QGroup.GROUP.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).innerJoin((EntityPath)QLicenseRoleGroup.LICENSE_ROLE_GROUP)).on((Predicate)QGroup.GROUP.lowerGroupName.eq((Expression)QLicenseRoleGroup.LICENSE_ROLE_GROUP.groupId.lower()))).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QLicenseRoleGroup.LICENSE_ROLE_GROUP.licenseRoleName.eq((Expression)QSchemePermissions.SCHEME_PERMISSIONS.parameter), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)permissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)"applicationRole")})).where((Predicate)QGroup.GROUP.active.eq((Object)1))).fetch());
    }

    @Override
    public List<UserDTO> findTopUsersFromTypeUser(String userSearchName, long schemeId, ProjectPermissionKey projectPermissionKey, int topN) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUser.USER).from((Expression)QUser.USER)).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QUser.USER.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).innerJoin((EntityPath)QApplicationUser.APPLICATION_USER)).on((Predicate)QApplicationUser.APPLICATION_USER.lowerUserName.eq((Expression)QUser.USER.lowerUserName))).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QSchemePermissions.SCHEME_PERMISSIONS.parameter.eq((Expression)QApplicationUser.APPLICATION_USER.userKey), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.USER.getKey())})).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QUser.USER.active.eq((Object)1), UserSearchUtilities.userSearchQueryDSLPredicate(userSearchName)}))).orderBy(QUser.USER.lowerDisplayName.asc())).distinct()).limit((long)topN)).fetch());
    }

    @Override
    public List<UserDTO> findTopUsersFromUserCF(String userSearchName, long schemeId, long issueId, ProjectPermissionKey projectPermissionKey, int topN) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUser.USER).from((Expression)QUser.USER)).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QUser.USER.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).innerJoin((EntityPath)QApplicationUser.APPLICATION_USER)).on((Predicate)QApplicationUser.APPLICATION_USER.lowerUserName.eq((Expression)QUser.USER.lowerUserName))).innerJoin((EntityPath)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on(new Predicate[]{QApplicationUser.APPLICATION_USER.userKey.eq((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.stringvalue), QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.eq((Object)issueId)})).innerJoin((EntityPath)QCustomField.CUSTOM_FIELD)).on((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield))).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QSchemePermissions.SCHEME_PERMISSIONS.parameter.eq((Expression)Expressions.asString((String)"customfield_").concat((Expression)QCustomField.CUSTOM_FIELD.id.stringValue())), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.USER_CUSTOM_FIELD.getKey())})).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QUser.USER.active.eq((Object)1), UserSearchUtilities.userSearchQueryDSLPredicate(userSearchName)}))).orderBy(QUser.USER.lowerDisplayName.asc())).distinct()).limit((long)topN)).fetch());
    }

    @Override
    public List<UserDTO> findTopUsersFromTypeProjectRoleUsers(String userSearchName, long schemeId, long projectId, ProjectPermissionKey projectPermissionKey, int topN) {
        return this.queryDslAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QUser.USER).from((Expression)QUser.USER)).innerJoin((EntityPath)QApplicationUser.APPLICATION_USER)).on((Predicate)QApplicationUser.APPLICATION_USER.lowerUserName.eq((Expression)QUser.USER.lowerUserName))).innerJoin((EntityPath)QDirectory.DIRECTORY)).on(new Predicate[]{QUser.USER.directoryId.eq(QDirectory.DIRECTORY.id), QDirectory.DIRECTORY.active.eq((Object)1)})).innerJoin((EntityPath)QProjectRoleActor.PROJECT_ROLE_ACTOR)).on(new Predicate[]{QProjectRoleActor.PROJECT_ROLE_ACTOR.roletypeparameter.eq((Expression)QApplicationUser.APPLICATION_USER.userKey), QProjectRoleActor.PROJECT_ROLE_ACTOR.pid.eq((Object)projectId), QProjectRoleActor.PROJECT_ROLE_ACTOR.roletype.eq((Object)"atlassian-user-role-actor")})).innerJoin((EntityPath)QSchemePermissions.SCHEME_PERMISSIONS)).on(new Predicate[]{QProjectRoleActor.PROJECT_ROLE_ACTOR.projectroleid.stringValue().eq((Expression)QSchemePermissions.SCHEME_PERMISSIONS.parameter), QSchemePermissions.SCHEME_PERMISSIONS.scheme.eq((Object)schemeId), QSchemePermissions.SCHEME_PERMISSIONS.permissionKey.eq((Object)projectPermissionKey.permissionKey()), QSchemePermissions.SCHEME_PERMISSIONS.type.eq((Object)JiraPermissionHolderType.PROJECT_ROLE.getKey())})).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{QUser.USER.active.eq((Object)1), UserSearchUtilities.userSearchQueryDSLPredicate(userSearchName)}))).orderBy(QUser.USER.lowerDisplayName.asc())).distinct()).limit((long)topN)).fetch());
    }
}

