/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.management;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.permission.management.ManagedPermissionSchemeEditingService;
import com.atlassian.jira.permission.management.ManagedPermissionSchemeHelper;
import com.atlassian.jira.permission.management.SecurityTypeValuesService;
import com.atlassian.jira.permission.management.beans.GrantToPermissionInputBean;
import com.atlassian.jira.permission.management.beans.PermissionsInputBean;
import com.atlassian.jira.permission.management.beans.ProjectExtPermissionBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionAddBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionOperationResultBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionRenderingBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionRenderingSectionBean;
import com.atlassian.jira.permission.management.beans.ProjectPermissionSchemeBean;
import com.atlassian.jira.permission.management.beans.SecurityTypeBean;
import com.atlassian.jira.permission.management.beans.SecurityTypeValueBean;
import com.atlassian.jira.permission.management.events.PermissionGrantedToSecurityTypeEvent;
import com.atlassian.jira.permission.management.events.PermissionRevokedFromSecurityTypeEvent;
import com.atlassian.jira.permission.management.events.SuccessfulPermissionSchemeGrantEvent;
import com.atlassian.jira.permission.management.events.SuccessfulPermissionSchemeRevokeEvent;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ManagedPermissionSchemeHelperImpl
implements ManagedPermissionSchemeHelper {
    public static final FeatureFlag EXTENDEDADMIN_HIDE_FEATURE = FeatureFlag.featureFlag((String)"admin.permissions.extendedadmin.hide.checkbox");
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionSchemeService permissionSchemeService;
    private final PermissionTypeManager permissionTypeManager;
    private final I18nHelper i18nHelper;
    private final SecurityTypeValuesService securityTypeValuesService;
    private final ManagedPermissionSchemeEditingService editingHelper;
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final FeatureManager featureManager;
    private final PermissionSchemeAttributeManager permissionSchemeAttributeManager;
    private final SoyTemplateRendererProvider soyTemplateRendererProvider;
    private final ImmutableList<SectionDefinition> SECTION_DEFINITIONS = ImmutableList.of((Object)new SectionDefinition("project", "admin.permission.group.project.permissions", this::getProjectPermissions), (Object)new SectionDefinition("issue", "admin.permission.group.issue.permissions", this::getIssuePermissions), (Object)new SectionDefinition("voterandwatcher", "admin.permission.group.voters.and.watchers.permissions", this::getVotersAndWatchersPermissions), (Object)new SectionDefinition("comment", "admin.permission.group.comments.permissions", this::getCommentsPermissions), (Object)new SectionDefinition("attachment", "admin.permission.group.attachments.permissions", this::getAttachmentsPermissions), (Object)new SectionDefinition("timetracking", "admin.permission.group.time.tracking.permissions", this::getTimeTrackingPermissions), (Object)new SectionDefinition("other", "admin.permission.group.other.permissions", this::getOtherPermissions));

    public ManagedPermissionSchemeHelperImpl(PermissionSchemeManager permissionSchemeManager, PermissionSchemeService permissionSchemeService, PermissionManager permissionManager, PermissionTypeManager permissionTypeManager, I18nHelper i18nHelper, SecurityTypeValuesService securityTypeValuesService, ManagedPermissionSchemeEditingService managedPermissionSchemeEditingService, EventPublisher eventPublisher, UserManager userManager, FeatureManager featureManager, PermissionSchemeAttributeManager permissionSchemeAttributeManager, SoyTemplateRendererProvider soyTemplateRendererProvider) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionSchemeService = permissionSchemeService;
        this.permissionManager = permissionManager;
        this.permissionTypeManager = permissionTypeManager;
        this.i18nHelper = i18nHelper;
        this.securityTypeValuesService = securityTypeValuesService;
        this.editingHelper = managedPermissionSchemeEditingService;
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        this.featureManager = featureManager;
        this.permissionSchemeAttributeManager = permissionSchemeAttributeManager;
        this.soyTemplateRendererProvider = soyTemplateRendererProvider;
    }

    @Override
    public Either<ErrorCollection, ProjectPermissionSchemeBean> getManagedPermissionScheme(ApplicationUser user, Long permissionSchemeId) {
        ServiceOutcome outcome = this.permissionSchemeService.getPermissionScheme(user, permissionSchemeId);
        if (!outcome.isValid()) {
            return Either.left((Object)outcome.getErrorCollection());
        }
        Scheme schemeObject = this.permissionSchemeManager.getSchemeObject(permissionSchemeId);
        if (schemeObject == null) {
            return Either.left((Object)this.schemeNotFound());
        }
        ArrayList allProjectPermissions = Lists.newArrayList(this.getAllProjectPermissions());
        Collections.sort(allProjectPermissions, (o1, o2) -> o1.getKey().compareTo(o2.getKey()));
        return Either.right((Object)this.generatePermissionSchemeBean(allProjectPermissions, (PermissionScheme)outcome.get()));
    }

    @Override
    public Either<ErrorCollection, ProjectPermissionAddBean> getManagedPermissionSchemeAddView(ApplicationUser user, Long permissionSchemeId, String permissionKey) {
        ServiceOutcome outcome = this.permissionSchemeService.getPermissionScheme(user, permissionSchemeId);
        if (!outcome.isValid()) {
            return Either.left((Object)outcome.getErrorCollection());
        }
        Scheme schemeObject = this.permissionSchemeManager.getSchemeObject(permissionSchemeId);
        if (schemeObject == null) {
            return Either.left((Object)this.schemeNotFound());
        }
        Option projectPermission = this.permissionManager.getProjectPermission(new ProjectPermissionKey(permissionKey));
        if (projectPermission.isEmpty()) {
            return Either.left((Object)this.schemeNotFound());
        }
        return Either.right((Object)this.generatePermissionSchemeAddBean((ProjectPermission)projectPermission.get(), user));
    }

    @Override
    public Either<ErrorCollection, ProjectPermissionAddBean> getManagedPermissionSchemeAddViewSecurityTypes(ApplicationUser user) {
        return Either.right((Object)ProjectPermissionAddBean.builder().setPrimarySecurityType(this.securityTypeValuesService.buildPrimarySecurityTypes(user)).setSecondarySecurityType(this.securityTypeValuesService.buildSecondarySecurityTypes(user)).build());
    }

    @Override
    public Either<ErrorCollection, ProjectPermissionSchemeBean> removeManagedPermissionSchemeGrants(ApplicationUser user, Long permissionSchemeId, List<Long> grantsToDelete) {
        Scheme schemeObject = this.permissionSchemeManager.getSchemeObject(permissionSchemeId);
        if (schemeObject == null) {
            return Either.left((Object)this.schemeNotFound());
        }
        if (grantsToDelete == null || grantsToDelete.isEmpty()) {
            return Either.left((Object)this.notFoundError("admin.errors.permissions.specify.permission.to.delete"));
        }
        this.triggerRevokeAnalyticsEvents(permissionSchemeId, grantsToDelete, user);
        this.permissionSchemeManager.deleteEntities(grantsToDelete);
        Either<ErrorCollection, ProjectPermissionSchemeBean> result = this.getManagedPermissionScheme(user, permissionSchemeId);
        if (result.isRight()) {
            String successMessageTranslationKey = "admin.permissions.feedback.successfuldelete." + (grantsToDelete.size() == 1 ? "single" : "multiple");
            this.addSuccessfulOperationDetails((ProjectPermissionSchemeBean)result.right().get(), this.i18nHelper.getText(successMessageTranslationKey));
        }
        return result;
    }

    @Override
    public Either<ErrorCollection, ProjectPermissionSchemeBean> addManagedPermissionSchemeGrants(ApplicationUser user, Long permissionSchemeId, PermissionsInputBean inputBean) {
        Scheme schemeObject = this.permissionSchemeManager.getSchemeObject(permissionSchemeId);
        if (schemeObject == null) {
            return Either.left((Object)this.schemeNotFound());
        }
        ErrorCollection errors = this.editingHelper.validateAddPermissions(user, inputBean);
        if (errors.hasAnyErrors()) {
            return Either.left((Object)errors);
        }
        this.editingHelper.addNewSecurityTypes(schemeObject, inputBean);
        Either<ErrorCollection, ProjectPermissionSchemeBean> result = this.getManagedPermissionScheme(user, permissionSchemeId);
        if (result.isRight()) {
            this.triggerGrantAnalyticsEvents(permissionSchemeId, inputBean);
            String successMessageTranslationKey = "admin.permissions.feedback.successfulgrant." + (inputBean.getPermissionKeys().size() == 1 ? "single" : "multiple");
            this.addSuccessfulOperationDetails((ProjectPermissionSchemeBean)result.right().get(), this.i18nHelper.getText(successMessageTranslationKey));
        }
        return result;
    }

    private void triggerRevokeAnalyticsEvents(Long permissionSchemeId, List<Long> grantsToDelete, ApplicationUser user) {
        if (grantsToDelete.isEmpty()) {
            return;
        }
        List deletedEntities = this.permissionSchemeManager.getEntitiesByIds(grantsToDelete);
        if (deletedEntities.isEmpty()) {
            return;
        }
        String analyticsPermissionKey = deletedEntities.stream().map(entity -> entity.get("permissionKey").toString()).sorted().distinct().collect(Collectors.joining(","));
        this.eventPublisher.publish((Object)new SuccessfulPermissionSchemeRevokeEvent(permissionSchemeId, analyticsPermissionKey, grantsToDelete.size()));
        deletedEntities.stream().forEach(entity -> this.eventPublisher.publish((Object)new PermissionRevokedFromSecurityTypeEvent(permissionSchemeId, entity.get("permissionKey").toString(), entity.get("type").toString())));
    }

    private void triggerGrantAnalyticsEvents(Long permissionSchemeId, PermissionsInputBean inputBean) {
        String analyticsSecurityType = inputBean.getGrants().stream().map(GrantToPermissionInputBean::getSecurityType).sorted().collect(Collectors.joining(","));
        this.eventPublisher.publish((Object)new SuccessfulPermissionSchemeGrantEvent(permissionSchemeId, analyticsSecurityType, inputBean.getPermissionKeys().size()));
        inputBean.getPermissionKeys().forEach(permissionKey -> this.eventPublisher.publish((Object)new PermissionGrantedToSecurityTypeEvent(permissionSchemeId, (String)permissionKey, analyticsSecurityType)));
    }

    private void addSuccessfulOperationDetails(ProjectPermissionSchemeBean projectPermissionSchemeBean, String message) {
        ProjectPermissionOperationResultBean operationResult = new ProjectPermissionOperationResultBean();
        operationResult.setType("success");
        operationResult.setMessages(Arrays.asList(message));
        projectPermissionSchemeBean.setOperationResult(operationResult);
    }

    private ProjectPermissionSchemeBean generatePermissionSchemeBean(Collection<ProjectPermission> allProjectPermissions, PermissionScheme effectivePermissionScheme) {
        Iterable permissionBeans = Iterables.transform(allProjectPermissions, projectPermission -> {
            ProjectPermissionKey permissionKey = projectPermission.getProjectPermissionKey();
            String descriptionI18nKey = projectPermission.getDescriptionI18nKey();
            String nameI18nKey = projectPermission.getNameI18nKey();
            ProjectExtPermissionBean extPermissionBean = this.getExtendedPermission(effectivePermissionScheme.getId(), permissionKey);
            List<SecurityTypeBean> securityTypeGrants = this.buildGrants(permissionKey, effectivePermissionScheme);
            return ProjectPermissionBean.builder().setPermissionKey(permissionKey.permissionKey()).setPermissionDesc(this.i18nHelper.getText(descriptionI18nKey)).setPermissionName(this.i18nHelper.getText(nameI18nKey)).setGrants(securityTypeGrants).setExtPermission(extPermissionBean).build();
        });
        ProjectPermissionSchemeBean.Builder builder = ProjectPermissionSchemeBean.builder().setId(effectivePermissionScheme.getId()).setName(effectivePermissionScheme.getName()).setDescription(effectivePermissionScheme.getDescription()).setPermissions(Lists.newArrayList((Iterable)permissionBeans)).setDisplayRendering(this.buildRenderingSections(this.i18nHelper));
        return builder.build();
    }

    private ProjectPermissionAddBean generatePermissionSchemeAddBean(ProjectPermission projectPermission, ApplicationUser user) {
        ProjectPermissionKey permissionKey = projectPermission.getProjectPermissionKey();
        String descriptionI18nKey = projectPermission.getDescriptionI18nKey();
        String nameI18nKey = projectPermission.getNameI18nKey();
        ProjectPermissionBean projectPermissionBean = ProjectPermissionBean.builder().setPermissionKey(permissionKey.permissionKey()).setPermissionDesc(this.i18nHelper.getText(descriptionI18nKey)).setPermissionName(this.i18nHelper.getText(nameI18nKey)).build();
        return ProjectPermissionAddBean.builder().setPermission(projectPermissionBean).setPrimarySecurityType(this.securityTypeValuesService.buildPrimarySecurityTypes(user)).setSecondarySecurityType(this.securityTypeValuesService.buildSecondarySecurityTypes(user)).build();
    }

    private ProjectExtPermissionBean getExtendedPermission(Long schemeId, ProjectPermissionKey key) {
        if (!this.featureManager.isEnabled(EXTENDEDADMIN_HIDE_FEATURE) && ProjectPermissions.ADMINISTER_PROJECTS.equals((Object)key)) {
            String attributeKey = "ADMINISTER_PROJECTS.extended.enabled";
            boolean isExtendedPermissionGranted = Boolean.valueOf((String)this.permissionSchemeAttributeManager.getAttribute(schemeId, "ADMINISTER_PROJECTS.extended.enabled").get());
            String endpointURI = MessageFormat.format("/rest/api/2/permissionscheme/{0,number,#}/attribute/{1}", schemeId, "ADMINISTER_PROJECTS.extended.enabled");
            String description = this.soyTemplateRendererProvider.getRenderer().render("jira.webresources:projectpermissions-common", "JIRA.Templates.ProjectPermissions.renderExtendedProjectAdminDescription", (Map)ImmutableMap.of());
            return ProjectExtPermissionBean.builder().setKey("ADMINISTER_PROJECTS.extended.enabled").setName(this.i18nHelper.getText("admin.permissions.EXT_PROJECT_ADMIN")).setDescription(description).setChecked(isExtendedPermissionGranted).setEndpointURI(endpointURI).build();
        }
        return null;
    }

    private List<SecurityTypeBean> buildGrants(ProjectPermissionKey permissionKey, PermissionScheme effectivePermissionScheme) {
        Collection permissionGrants = effectivePermissionScheme.getPermissions();
        ArrayList grantsForPermissionKey = Lists.newArrayList((Iterable)Iterables.filter((Iterable)permissionGrants, input -> permissionKey.equals((Object)input.getPermission())));
        ArrayListMultimap groupedSecurityTypeInstances = ArrayListMultimap.create();
        for (PermissionGrant permissionGrant : grantsForPermissionKey) {
            SecurityTypeMapKey bySecurityType = new SecurityTypeMapKey(permissionGrant.getHolder(), permissionGrant.getHolder().getType());
            groupedSecurityTypeInstances.put((Object)bySecurityType, (Object)permissionGrant);
        }
        ArrayList<SecurityTypeBean> grants = new ArrayList<SecurityTypeBean>();
        for (SecurityTypeMapKey securityTypeMapKey : groupedSecurityTypeInstances.keySet()) {
            PermissionHolder permissionHolder = securityTypeMapKey.permissionHolder;
            SecurityType securityType = this.getSecurityType(permissionHolder);
            SecurityTypeBean.Builder builder = SecurityTypeBean.builder().setSecurityType(permissionHolder.getType().getKey()).setDisplayName(securityType.getDisplayName());
            List typedGrants = groupedSecurityTypeInstances.get((Object)securityTypeMapKey);
            for (PermissionGrant typedGrant : typedGrants) {
                PermissionHolder typedGrantHolder = typedGrant.getHolder();
                SecurityTypeValueBean.Builder securityTypeValueBeanBuilder = SecurityTypeValueBean.builder().setId(typedGrant.getId()).setValue((String)typedGrantHolder.getParameter().getOrNull()).setDisplayValue(this.getParameterDisplayValue(typedGrant));
                if (JiraPermissionHolderType.USER.getKey().equals(typedGrantHolder.getType().getKey())) {
                    ApplicationUser user = this.userManager.getUserByNameEvenWhenUnknown((String)typedGrantHolder.getParameter().getOrNull());
                    securityTypeValueBeanBuilder.setValid(this.userManager.isUserExisting(user));
                }
                builder.addValue(securityTypeValueBeanBuilder.build());
            }
            grants.add(builder.build());
        }
        this.securityTypeValuesService.sort(grants);
        return grants;
    }

    private String getParameterDisplayValue(PermissionGrant typedGrant) {
        Option parameter = typedGrant.getHolder().getParameter();
        if (parameter.isDefined()) {
            SecurityType securityType = this.getSecurityType(typedGrant.getHolder());
            return securityType.getArgumentDisplay((String)parameter.get());
        }
        return null;
    }

    private SecurityType getSecurityType(PermissionHolder permissionHolder) {
        Map securityTypes = this.permissionTypeManager.getTypes();
        return (SecurityType)securityTypes.get(permissionHolder.getType().getKey());
    }

    private ErrorCollection notFoundError(String key) {
        return new SimpleErrorCollection(this.i18nHelper.getText(key), ErrorCollection.Reason.NOT_FOUND);
    }

    private ErrorCollection schemeNotFound() {
        return this.notFoundError("admin.permissions.errors.mustselectscheme");
    }

    private ProjectPermissionRenderingBean buildRenderingSections(I18nHelper i18nHelper) {
        ArrayList sections = Lists.newArrayList();
        for (SectionDefinition sectionDef : this.SECTION_DEFINITIONS) {
            ProjectPermissionRenderingSectionBean.Builder sectionBuilder = ProjectPermissionRenderingSectionBean.builder();
            sectionBuilder.setSectionType(sectionDef.sectionType);
            sectionBuilder.setHeading(i18nHelper.getText(sectionDef.i18nKey));
            sectionBuilder.addPermissions(Iterables.transform((Iterable)((Iterable)sectionDef.permissions.get()), ProjectPermission::getKey));
            sections.add(sectionBuilder.build());
        }
        return new ProjectPermissionRenderingBean(true, sections);
    }

    private Collection<ProjectPermission> getAllProjectPermissions() {
        return this.permissionManager.getAllProjectPermissions();
    }

    private Collection<ProjectPermission> getProjectPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.PROJECTS);
    }

    private Collection<ProjectPermission> getIssuePermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ISSUES);
    }

    private Collection<ProjectPermission> getVotersAndWatchersPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.VOTERS_AND_WATCHERS);
    }

    private Collection<ProjectPermission> getTimeTrackingPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.TIME_TRACKING);
    }

    private Collection<ProjectPermission> getCommentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.COMMENTS);
    }

    private Collection<ProjectPermission> getAttachmentsPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.ATTACHMENTS);
    }

    private Collection<ProjectPermission> getOtherPermissions() {
        return this.permissionManager.getProjectPermissions(ProjectPermissionCategory.OTHER);
    }

    private static class SectionDefinition {
        private String sectionType;
        private String i18nKey;
        private Supplier<Collection<ProjectPermission>> permissions;

        private SectionDefinition(String sectionType, String i18nKey, Supplier<Collection<ProjectPermission>> permissions) {
            this.sectionType = (String)Preconditions.checkNotNull((Object)sectionType);
            this.i18nKey = (String)Preconditions.checkNotNull((Object)i18nKey);
            this.permissions = (Supplier)Preconditions.checkNotNull(permissions);
        }
    }

    static class SecurityTypeMapKey {
        private final PermissionHolder permissionHolder;
        private final PermissionHolderType permissionHolderType;

        SecurityTypeMapKey(PermissionHolder permissionHolder, PermissionHolderType permissionHolderType) {
            this.permissionHolder = permissionHolder;
            this.permissionHolderType = permissionHolderType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SecurityTypeMapKey that = (SecurityTypeMapKey)o;
            return this.permissionHolderType.equals(that.permissionHolderType);
        }

        public int hashCode() {
            return this.permissionHolderType.hashCode();
        }
    }
}

