/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.annotations.Internal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.cluster.cache.pauser.ReplicationPauserManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JiraCacheResetter
implements InitializingComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JiraCacheResetter.class);
    private static final String LOG_PREFIX = "[jira-cache-reseter] ";
    private final Delegate delegate;

    public JiraCacheResetter(EventPublisher eventPublisher, ReplicationPauserManager replicationPauserManager) {
        this.delegate = new Delegate(replicationPauserManager);
        eventPublisher.register((Object)this.delegate);
        LOG.info("[jira-cache-reseter] Created and registered for events");
    }

    @Override
    public void afterInstantiation() throws Exception {
        LOG.info("[jira-cache-reseter] Initialized.");
    }

    public static class Delegate {
        private volatile boolean jiraIsShuttingDown = false;
        private final ReplicationPauserManager replicationPauserManager;

        Delegate(ReplicationPauserManager replicationPauserManager) {
            this.replicationPauserManager = replicationPauserManager;
        }

        @EventListener
        public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
            this.resetCachesAndLog(String.format("onJiraPluginCacheResetEvent(%s)", event.numberOfEvents()));
        }

        @EventListener
        public void onClearCacheEvent(ClearCacheEvent event) {
            this.resetCachesIfJiraNotShuttingDown("onClearCacheEvent()");
        }

        private void resetCachesAndLog(String triggeredBy) {
            this.replicationPauserManager.pauseReplicationFor(() -> {
                Stopwatch stopwatch = Stopwatch.createStarted();
                LOG.debug("[jira-cache-reseter] Start resetting caches triggered by: {}, jiraIsShuttingDown: {}", (Object)triggeredBy, (Object)this.jiraIsShuttingDown);
                this.resetCachesIfJiraNotShuttingDown(triggeredBy);
                LOG.debug("[jira-cache-reseter] Done resetting caches triggered by: {}, timeMillis: {}, jiraIsShuttingDown: {}", new Object[]{triggeredBy, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), this.jiraIsShuttingDown});
            }, triggeredBy);
        }

        @EventListener
        public void onJiraShuttingDown(ComponentManagerShutdownEvent shutdownEvent) {
            this.jiraIsShuttingDown = true;
        }

        private void resetCachesIfJiraNotShuttingDown(String triggeredBy) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOG.debug("Start resetting caches triggered by: {}, jiraIsShuttingDown: {}", (Object)triggeredBy, (Object)this.jiraIsShuttingDown);
            if (this.jiraIsShuttingDown) {
                return;
            }
            this.resetCaches();
            LOG.debug("Done resetting caches triggered by: {}, timeMillis: {}, jiraIsShuttingDown: {}", new Object[]{triggeredBy, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), this.jiraIsShuttingDown});
        }

        private void resetCaches() {
            PortletConfigurationStore store;
            FieldScreenManager screenManager;
            FieldManager fieldManager;
            CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
            if (customFieldManager != null) {
                customFieldManager.refresh();
            }
            if ((fieldManager = ComponentAccessor.getFieldManager()) != null) {
                fieldManager.refresh();
            }
            if ((screenManager = ComponentAccessor.getFieldScreenManager()) != null) {
                screenManager.refresh();
            }
            if ((store = (PortletConfigurationStore)ComponentAccessor.getComponent(PortletConfigurationStore.class)) instanceof FlushablePortletConfigurationStore) {
                ((FlushablePortletConfigurationStore)store).flush();
            }
            PropertyUtils.clearDescriptors();
        }
    }
}

