/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.freeze;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;

public class FreezeFileManager {
    private final EventPublisher eventPublisher;
    private final File freezeFile;
    private final File installedPluginsDirectory;

    FreezeFileManager(EventPublisher eventPublisher, File freezeFile, File installedPluginsDirectory) {
        this.eventPublisher = eventPublisher;
        this.freezeFile = freezeFile;
        this.installedPluginsDirectory = installedPluginsDirectory;
    }

    public void freeze() {
        try (Stream<Path> installedPlugins = Files.list(this.installedPluginsDirectory.toPath());){
            Stream<CharSequence> fileContent = installedPlugins.map(Path::toAbsolutePath).map(this.freezeFile.getParentFile().toPath()::relativize).map(Path::toString);
            com.google.common.io.Files.asCharSink((File)this.freezeFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).writeLines(fileContent::iterator, "\n");
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_ADD, JiraHomeChangeEvent.FileType.PLUGIN, this.freezeFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void unfreeze() {
        try {
            Files.delete(this.freezeFile.toPath());
            this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.PLUGIN, this.freezeFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUnfrozenPlugins() {
        try {
            Set<Path> unfrozenPlugins = this.getUnfrozenPlugins();
            for (Path unfrozenPlugin : unfrozenPlugins) {
                Files.delete(unfrozenPlugin);
                this.eventPublisher.publish((Object)new JiraHomeChangeEvent(JiraHomeChangeEvent.Action.FILE_DELETED, JiraHomeChangeEvent.FileType.PLUGIN, unfrozenPlugin.toFile()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isPluginInFreezeFile(Path plugin) {
        try {
            return this.freezeFile.exists() && this.getFrozenPlugins().contains(plugin);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Set<Path> getFrozenPlugins() throws IOException {
        return (Set)com.google.common.io.Files.asCharSource((File)this.freezeFile, (Charset)Charsets.UTF_8).readLines().stream().map(this.freezeFile.toPath().getParent()::resolve).collect(CollectorsUtil.toImmutableSet());
    }

    private Set<Path> getUnfrozenPlugins() throws IOException {
        Set<Path> frozenPlugins = this.getFrozenPlugins();
        try (Stream<Path> installedPlugins = Files.list(this.installedPluginsDirectory.toPath());){
            Set set = (Set)installedPlugins.filter(plugin -> !frozenPlugins.contains(plugin)).collect(CollectorsUtil.toImmutableSet());
            return set;
        }
    }
}

