/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.freeze;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.TreeSet;

public class SwitchingScanner
implements Scanner {
    private final Scanner originalScanner;
    private final Scanner alternateScanner;
    private volatile Scanner activeScanner;
    private Collection<DeploymentUnit> unitsForNextScan;
    private Collection<DeploymentUnit> unitsAtLastScan;

    public SwitchingScanner(Scanner originalScanner, Scanner alternateScanner) {
        this.originalScanner = originalScanner;
        this.alternateScanner = alternateScanner;
        this.activeScanner = originalScanner;
    }

    public Scanner getActiveScanner() {
        return this.activeScanner;
    }

    public boolean isAlternate() {
        return this.activeScanner == this.alternateScanner;
    }

    public void switchTo(boolean alternate) {
        this.switchTo(alternate ? this.alternateScanner : this.originalScanner);
    }

    private synchronized void switchTo(Scanner scanner) {
        if (this.unitsAtLastScan != null) {
            TreeSet oldSet = Sets.newTreeSet(this.unitsAtLastScan);
            scanner.scan();
            TreeSet difference = Sets.newTreeSet((Iterable)scanner.getDeploymentUnits());
            difference.removeAll(oldSet);
            this.unitsForNextScan = difference;
        }
        this.activeScanner = scanner;
    }

    public synchronized Collection<DeploymentUnit> scan() {
        Scanner activeScanner = this.activeScanner;
        Collection scan = activeScanner.scan();
        this.unitsAtLastScan = ImmutableList.copyOf((Collection)activeScanner.getDeploymentUnits());
        if (this.unitsForNextScan != null) {
            ImmutableList ret = ImmutableList.builder().addAll(this.unitsForNextScan).addAll((Iterable)scan).build();
            this.unitsForNextScan = null;
            return ret;
        }
        return scan;
    }

    public Collection<DeploymentUnit> getDeploymentUnits() {
        return this.activeScanner.getDeploymentUnits();
    }

    public void reset() {
        this.activeScanner.reset();
    }

    public void remove(DeploymentUnit unit) throws PluginException {
        this.activeScanner.remove(unit);
    }
}

