/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderercomponent;

import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.plugin.renderercomponent.RendererComponentFactoryDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.V2SubRenderer;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import com.atlassian.renderer.v2.components.RendererComponent;
import com.atlassian.renderer.v2.components.block.BlockRenderer;
import com.atlassian.renderer.v2.components.block.BlockRendererComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BlockRendererComponentFactory
implements PluggableRendererComponentFactory {
    private RendererComponent rendererComponent;
    private static final String BLOCKRENDERERS_PARAM = "blockrenderers";
    private final V2SubRenderer subRenderer;

    public BlockRendererComponentFactory(V2SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void init(ModuleDescriptor moduleDescriptor) throws PluginParseException {
        RendererComponentFactoryDescriptor descriptor = (RendererComponentFactoryDescriptor)moduleDescriptor;
        Map<String, List<String>> listParams = descriptor.getListParams();
        if (!listParams.containsKey(BLOCKRENDERERS_PARAM)) {
            throw new PluginParseException("Could not load block renderer component factory with key '" + descriptor.getCompleteKey() + "'. Missing required list-param '" + BLOCKRENDERERS_PARAM + "'");
        }
        List<String> blockRendererClasses = listParams.get(BLOCKRENDERERS_PARAM);
        ArrayList blockRendererObjects = Lists.newArrayListWithCapacity((int)blockRendererClasses.size());
        Iterator<String> iterator = blockRendererClasses.iterator();
        while (iterator.hasNext()) {
            String blockRendererClassObj;
            String blockRendererClass = blockRendererClassObj = iterator.next();
            try {
                blockRendererObjects.add(this.loadBlockRenderer(blockRendererClass, moduleDescriptor.getPlugin()));
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Could not load block renderer class '" + blockRendererClass + "' for renderer component plugin with key '" + descriptor.getCompleteKey() + "'", (Throwable)e);
            }
        }
        this.rendererComponent = new BlockRendererComponent((SubRenderer)this.subRenderer, (List)blockRendererObjects);
    }

    BlockRenderer loadBlockRenderer(String blockRendererClassName, Plugin plugin) throws ClassNotFoundException {
        Class blockRendererClass = plugin.loadClass(blockRendererClassName, this.getClass());
        return (BlockRenderer)ComponentManager.getInstance().loadComponent(blockRendererClass, Collections.emptyList());
    }

    public RendererComponent getRendererComponent() {
        return this.rendererComponent;
    }
}

