/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.renderercomponent;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.renderer.v2.components.PluggableRendererComponentFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Element;

public class RendererComponentFactoryDescriptor
extends AbstractJiraModuleDescriptor<PluggableRendererComponentFactory>
implements OrderableModuleDescriptor {
    public static final String USE_OLD_IMAGE_RENDERER_ORDER = "jira.wiki.use.old.image.renderer.order";
    private static final int OLD_IMAGE_RENDERER_ORDER = 105;
    private int order = 0;
    private final Map<String, List<String>> listParams = new HashMap<String, List<String>>();
    private final FeatureManager featureManager;

    public RendererComponentFactoryDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory, FeatureManager featureManager) {
        super(authenticationContext, moduleFactory);
        this.featureManager = featureManager;
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        List valueElements;
        super.init(plugin, element);
        Element paramListElement = element.element("list-param");
        if (paramListElement != null && (valueElements = paramListElement.elements("value")) != null) {
            List paramList = valueElements.stream().map(Element::getTextTrim).collect(Collectors.toList());
            this.listParams.put(paramListElement.attribute("name").getText(), paramList);
        }
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    @Override
    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(PluggableRendererComponentFactory.class);
    }

    public Map<String, List<String>> getListParams() {
        return this.listParams;
    }

    public int getOrder() {
        if ("embeddedimagerenderer".equals(this.key) && this.featureManager.isEnabled(USE_OLD_IMAGE_RENDERER_ORDER)) {
            return 105;
        }
        return this.order;
    }

    public boolean hasHelp() {
        return this.getResourceDescriptor("velocity", "help") != null;
    }

    public String getHelpSection() {
        return this.getResourceDescriptor("velocity", "help").getParameter("help-section");
    }

    public String getHelp() {
        return this.getHtml("help");
    }
}

