/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionOptionalValuesGenerator
implements ValuesGenerator<Long> {
    private static final Logger log = LoggerFactory.getLogger(VersionOptionalValuesGenerator.class);

    public Map getValues(Map params) {
        GenericValue projectGV = (GenericValue)params.get("project");
        ApplicationUser remoteUser = (ApplicationUser)params.get("User");
        try {
            VersionManager versionManager = ComponentAccessor.getVersionManager();
            I18nBean i18n = new I18nBean(remoteUser);
            Collection unreleasedVersions = versionManager.getVersionsUnreleased(projectGV.getLong("id"), false);
            OrderedMap unreleased = ListOrderedMap.decorate(new HashMap(unreleasedVersions.size()));
            Iterator unreleasedIter = unreleasedVersions.iterator();
            if (unreleasedIter.hasNext()) {
                unreleased.put(new Long(-2L), i18n.getText("common.filters.unreleasedversions"));
                while (unreleasedIter.hasNext()) {
                    Version version = (Version)unreleasedIter.next();
                    unreleased.put(version.getId(), "- " + version.getName());
                }
            }
            OrderedMap released = ListOrderedMap.decorate(new HashMap(unreleasedVersions.size()));
            ArrayList releasedIter = new ArrayList(versionManager.getVersionsReleased(projectGV.getLong("id"), false));
            if (!releasedIter.isEmpty()) {
                released.put(new Long(-3L), i18n.getText("common.filters.releasedversions"));
                Collections.reverse(releasedIter);
                for (Version version : releasedIter) {
                    released.put(version.getId(), "- " + version.getName());
                }
            }
            int size = unreleased.size() + released.size() + 1;
            OrderedMap versions = ListOrderedMap.decorate(new HashMap(size));
            versions.put(new Long(-1L), i18n.getText("timetracking.nofixversion"));
            versions.putAll(unreleased);
            versions.putAll(released);
            return versions;
        }
        catch (Exception e) {
            log.error("Could not retrieve versions for the project: " + (projectGV != null ? projectGV.getString("id") : "Project is null."), (Throwable)e);
            return null;
        }
    }
}

