/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.archiving;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.model.querydsl.QIssue;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.SQLQuery;
import java.util.concurrent.TimeUnit;

public class ArchivedStatistics {
    private final CachedReference<ArchivedStatisticsData> issuesCountCache;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final QueryDslAccessor queryDslAccessor;

    public ArchivedStatistics(CacheManager cacheManager, ProjectManager projectManager, IssueManager issueManager, QueryDslAccessor queryDslAccessor) {
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.queryDslAccessor = queryDslAccessor;
        this.issuesCountCache = cacheManager.getCachedReference(ArchivedProjectManager.class.getName() + ".cache", this::calculateArchivedStatisticsData, new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).replicateViaInvalidation().build());
    }

    public void invalidate() {
        this.issuesCountCache.reset();
    }

    public int getTotalArchivedIssuesCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getTotalArchivedIssuesCount();
    }

    public int getIssuesInArchivedProjectsCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getIssuesInArchivedProjectsCount();
    }

    public int getArchivedIssuesCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getArchivedIssuesCount();
    }

    private int countIssuesInArchivedProjects() {
        return (int)this.projectManager.getArchivedProjects().stream().mapToLong(project -> this.issueManager.getIssueCountForProject(project.getId())).sum();
    }

    private int countIndividuallyArchivedIssues() {
        return this.countIssuesWhere((Predicate)QIssue.ISSUE.archived.eq((Object)DatabaseUtil.booleanToChar1(true)).and((Predicate)QIssue.ISSUE.archivedby.isNotNull()).and((Predicate)QIssue.ISSUE.archiveddate.isNotNull()));
    }

    private int countTotalArchivedIssues() {
        return this.countIssuesWhere((Predicate)QIssue.ISSUE.archived.eq((Object)DatabaseUtil.booleanToChar1(true)));
    }

    private int countIssuesWhere(Predicate condition) {
        return (int)this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(Expressions.constant((Object)1)).from((Expression)QIssue.ISSUE)).where(condition)).fetchCount()).longValue();
    }

    private ArchivedStatisticsData calculateArchivedStatisticsData() {
        return new ArchivedStatisticsData(this.countTotalArchivedIssues(), this.countIndividuallyArchivedIssues(), this.countIssuesInArchivedProjects());
    }

    private static class ArchivedStatisticsData {
        private final int totalArchivedIssuesCount;
        private final int archivedIssuesCount;
        private final int issuesInArchivedProjectsCount;

        ArchivedStatisticsData(int totalArchivedIssuesCount, int archivedIssuesCount, int issuesInArchivedProjectsCount) {
            this.totalArchivedIssuesCount = totalArchivedIssuesCount;
            this.archivedIssuesCount = archivedIssuesCount;
            this.issuesInArchivedProjectsCount = issuesInArchivedProjectsCount;
        }

        int getTotalArchivedIssuesCount() {
            return this.totalArchivedIssuesCount;
        }

        int getArchivedIssuesCount() {
            return this.archivedIssuesCount;
        }

        int getIssuesInArchivedProjectsCount() {
            return this.issuesInArchivedProjectsCount;
        }
    }
}

