/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.util;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@EventComponent
public class CachingProjectKeyStore
implements ProjectKeyStore {
    private final ProjectKeyStore delegateProjectKeyStore;
    private final CachedReference<ProjectKeyCache> cache;

    public CachingProjectKeyStore(ProjectKeyStore delegateProjectKeyStore, CacheManager cacheManager) {
        this.delegateProjectKeyStore = delegateProjectKeyStore;
        this.cache = cacheManager.getCachedReference(this.getClass().getName() + ".cache", () -> new ProjectKeyCache(delegateProjectKeyStore.getAllProjectKeys()));
        this.refresh();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    @Nullable
    public Long getProjectId(String key) {
        return ((ProjectKeyCache)this.cache.get()).getProjectId(key);
    }

    @Override
    public void addProjectKey(Long projectId, String projectKey) {
        this.delegateProjectKeyStore.addProjectKey(projectId, projectKey);
        this.refresh();
    }

    @Override
    public void deleteProjectKeys(Long projectId) {
        this.delegateProjectKeyStore.deleteProjectKeys(projectId);
        this.refresh();
    }

    @Override
    @Nonnull
    public Map<String, Long> getAllProjectKeys() {
        return ((ProjectKeyCache)this.cache.get()).getAllProjectKeys();
    }

    @Override
    @Nullable
    public Long getProjectIdByKeyIgnoreCase(String projectKey) {
        return ((ProjectKeyCache)this.cache.get()).getProjectIdByKeyIgnoreCase(projectKey);
    }

    @Override
    @Nonnull
    public Set<String> getProjectKeys(Long projectId) {
        return ((ProjectKeyCache)this.cache.get()).getProjectKeys(projectId);
    }

    @Override
    public void refresh() {
        this.cache.reset();
    }

    static class ProjectKeyCache {
        private final ImmutableMap<String, Long> projectsByKey;
        private final ImmutableSetMultimap<Long, String> projectKeys;
        private final ImmutableMap<String, Long> projectsByKeyIgnoreCase;

        public ProjectKeyCache(Map<String, Long> projects) {
            HashMultimap tmpProjectKeys = HashMultimap.create();
            for (Map.Entry<String, Long> projectKey : projects.entrySet()) {
                tmpProjectKeys.put((Object)projectKey.getValue(), (Object)projectKey.getKey());
            }
            this.projectsByKey = ImmutableMap.copyOf(projects);
            this.projectKeys = ImmutableSetMultimap.copyOf((Multimap)tmpProjectKeys);
            this.projectsByKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        }

        @Nullable
        public Long getProjectId(String key) {
            return (Long)this.projectsByKey.get((Object)key);
        }

        @Nonnull
        public Map<String, Long> getAllProjectKeys() {
            return this.projectsByKey;
        }

        @Nonnull
        public Set<String> getProjectKeys(Long projectId) {
            return this.projectKeys.get((Object)projectId);
        }

        @Nullable
        public Long getProjectIdByKeyIgnoreCase(String projectKey) {
            return (Long)this.projectsByKeyIgnoreCase.get((Object)projectKey);
        }
    }
}

