/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.cache.CacheManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.DatabaseImportCompletedEvent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.DbBackedPropertySetManager;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.properties.ZDUDbBackedCachedPropertySetManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.ProjectPropertiesManager;
import com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore;
import com.atlassian.jira.user.UserPropertyManager;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@ParametersAreNonnullByDefault
public class ComponentCachingOfBizPropertyEntryStore
extends CachingOfBizPropertyEntryStore {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentCachingOfBizPropertyEntryStore.class);
    private final Map<String, Class> entityNamesByNewOwners = ImmutableMap.of((Object)"Project", ProjectPropertiesManager.class, (Object)"ApplicationUser", UserPropertyManager.class, (Object)"jira.properties", DbBackedPropertySetManager.class);
    private final Map<String, AtomicLong> entityNamesByWarningCounter = ImmutableMap.of((Object)"Project", (Object)new AtomicLong(0L), (Object)"ApplicationUser", (Object)new AtomicLong(0L), (Object)"jira.properties", (Object)new AtomicLong(0L));
    static final int LOGGER_WARNING_FREQUENCY = JiraSystemProperties.getInstance().getInteger("com.atlassian.jira.propertyset.warning.frequency", Integer.valueOf(100000));
    private static final String WARNING_MESSAGE = "Looking for entityName: {} in the wrong cache. This entity was moved to: {}. Warning counter: {}. This may happen in ZDU or during initial Jira setup. Only investigate if this is happening post ZDU/initial Jira setup. Enable trace logging for this class to see the stack trace for every illegal call. Current database version number: {}.";

    public ComponentCachingOfBizPropertyEntryStore(QueryDslAccessor queryDslAccessor, CacheManager cacheManager, EventListenerRegistrar eventListenerRegistrar) {
        super(CachingOfBizPropertyEntryStore.class.getName() + ".cache", queryDslAccessor, cacheManager, true);
        eventListenerRegistrar.register((Object)this);
    }

    @Override
    protected void validateEntityName(String entityName) {
        Class otherEntityNameOwner = this.entityNamesByNewOwners.get(entityName);
        if (otherEntityNameOwner != null) {
            AtomicLong counter = this.entityNamesByWarningCounter.get(entityName);
            long counterValue = counter.incrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.trace(WARNING_MESSAGE, new Object[]{entityName, otherEntityNameOwner.getName(), counterValue, this.getCurrentDatabaseVersion_expensive(), new Throwable()});
            }
            if (counterValue == 1L || counterValue % (long)LOGGER_WARNING_FREQUENCY == 0L) {
                LOG.warn(WARNING_MESSAGE, new Object[]{entityName, otherEntityNameOwner.getName(), counterValue, this.getCurrentDatabaseVersion_expensive()});
            }
        }
    }

    private String getCurrentDatabaseVersion_expensive() {
        return Optional.ofNullable(ComponentAccessor.getComponent(ZDUDbBackedCachedPropertySetManager.class)).map(zduDbBackedCachedPropertySetManager -> "" + zduDbBackedCachedPropertySetManager.getDatabaseBuildNumber()).orElse("n/a");
    }

    @EventListener
    public void onClearCache(@Nullable ClearCacheEvent event) {
        this.refreshAll();
    }

    @EventListener
    public void onDatabaseImportCompleted(DatabaseImportCompletedEvent event) {
        this.refreshAll();
    }
}

